import 'package:flutter/material.dart';
import 'package:flutter_bmfmap_example/CustomWidgets/function_item.widget.dart';
import 'package:flutter_bmfmap_example/CustomWidgets/map_appbar.dart';
import 'package:flutter_bmfmap_example/DemoPages/Interact/show_mapinteract_page.dart';
import 'package:flutter_bmfmap_example/DemoPages/Interact/show_mapscreenshot_page.dart';
import 'package:flutter_bmfmap_example/DemoPages/Interact/show_mapzoom_page.dart';

/// 地图交互入口
class ShowInteractPage extends StatelessWidget {
  const ShowInteractPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: BMFAppBar(
          title: '与地图交互',
          isBack: false,
        ),
        body: Container(
            child: ListView(children: <Widget>[
          FunctionItem(
            label: '地图交互示例',
            sublabel: '修改地图中心点，以及触摸点、poi点显示',
            target: ShowMapInteractPage(),
          ),
          FunctionItem(
            label: '地图截图示例',
            sublabel: '截图及其事件响应',
            target: ShowMapScreenshotPage(),
          ),
          FunctionItem(
            label: '缩放地图示例',
            sublabel: 'ShowMapZoomPage',
            target: ShowMapZoomPage(),
          ),
        ])));
  }
}
