import 'package:flutter/material.dart';

/// 大头针点击事件
typedef MapPinClick = Function();

/// 地图中心点的大头针
class MapPinPage extends StatefulWidget {
  //是否开启动画
  final bool isAnimation;

  const MapPinPage(this.isAnimation, {Key? key}) : super(key: key);

  @override
  MapPinPageState createState() => MapPinPageState();
}

class MapPinPageState extends State<MapPinPage>
    with SingleTickerProviderStateMixin {
  AnimationController? _animationController;
  Animation? _changeSize;
  Animation? _scaleSize;

  @override
  void initState() {
    super.initState();
    initAnimation();
  }

  void initAnimation() {
    // 创建动画
    _animationController = AnimationController(
        duration: const Duration(milliseconds: 300), vsync: this);
    _changeSize = TweenSequence([
      TweenSequenceItem(
          tween: Tween(begin: 0.0, end: 6.0)
              .chain(CurveTween(curve: Curves.easeOut)),
          weight: 50),
    ]).animate(_animationController!);
    _scaleSize =
        Tween(begin: 10.0, end: 25.0).animate(_animationController!); // 修改尺寸动画
    _animationController!.addStatusListener((status) {
      if (status == AnimationStatus.forward) {
      } else if (status == AnimationStatus.completed) {
        _animationController!.reverse();
      } else if (status == AnimationStatus.dismissed) {
        _animationController!.reset();
        startAnimation();
      }
    });
  }

  @override
  void dispose() {
    _animationController!.dispose();
    super.dispose();
  }

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  /// 开始播放动画
  void startAnimation() async {
    _animationController!.forward();
  }

  @override
  Widget build(BuildContext context) {
    return Visibility(
      visible: true,
      child: Center(
        child: Container(
          height: 95,
          child: Stack(
            fit: StackFit.expand,
            children: [
              AnimatedBuilder(
                animation: _animationController!,
                builder: (context, child) {
                  return Positioned(
                    left: 0,
                    right: 0,
                    bottom: _changeSize!.value,
                    child: Column(
                      key: ValueKey<bool>(!widget.isAnimation),
                      children: [
                        Container(
                          width: 30,
                          height: 30,
                          decoration: const BoxDecoration(
                            color: Color(0xFF06C584),
                            shape: BoxShape.circle,
                          ),
                          child: Center(
                            child: Container(
                              key: ValueKey<bool>(!widget.isAnimation),
                              height: _scaleSize!.value,
                              width: _scaleSize!.value,
                              decoration: const BoxDecoration(
                                color: Colors.white,
                                shape: BoxShape.circle,
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  );
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}
