import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_baidu_mapapi_map/flutter_baidu_mapapi_map.dart';
import 'package:flutter_baidu_mapapi_base/flutter_baidu_mapapi_base.dart';

import 'map_pin.dart';

class MapDemo extends StatefulWidget {
  const MapDemo({Key? key}) : super(key: key);

  @override
  State<MapDemo> createState() => _MapDemoState();
}

class _MapDemoState extends State<MapDemo> {
  final GlobalKey<MapPinPageState> animationKey = GlobalKey<MapPinPageState>();
  BMFMapOptions? mapOptions = BMFMapOptions(
      mapType: BMFMapType.Standard,
      showIndoorMapPoi: false,
      //设定室内图标注是否显示，默认true，仅当显示室内图（baseIndoorMapEnabled为true）时生效
      zoomLevel: 19,
      maxZoomLevel: 21,
      minZoomLevel: 4,
      showZoomControl: false,
      backgroundImage: '',
      logoPosition: BMFLogoPosition.LeftBottom,
      mapPadding: BMFEdgeInsets(top: 0, left: 50, right: 50, bottom: 0),
      overlookEnabled: false,
      rotateEnabled: false,
      showOperateLayer: false,
      showMapScaleBar: false,
      center: BMFCoordinate(31.30425054225761, 120.59187592787157),
      showDEMLayer: true,
      doubleClickGesturesEnable: true, //双击设置 屏幕中心放大缩小
      changeCenterWithDoubleTouchPointEnabled: false);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("map_demo"),
      ),
      body: Column(
        children: [
          Container(
              margin: EdgeInsets.symmetric(horizontal: 10),
              color: Colors.white.withOpacity(0.7),
              child: Container(
                padding: EdgeInsets.all(2),
                alignment: Alignment.center,
                height: 350,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.zero, topRight: Radius.circular(12)),
                  color: Colors.white,
                ),
                child: ClipRRect(
                    borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(10),
                        topRight: Radius.circular(10)),
                    child: Stack(
                      alignment: Alignment.center,
                      children: [
                        BMFMapWidget(
                          onBMFMapCreated: (mapController) {},
                          mapOptions: mapOptions,
                        ),
                        Positioned(
                          left: 0,
                          right: 0,
                          top: 0,
                          bottom: 90,
                          child: MapPinPage(
                            true,
                            key: animationKey,
                          ),
                        ),
                        Positioned(
                            right: 10,
                            bottom: 44,
                            child: GestureDetector(
                              onTap: () {
                                animationKey.currentState?.startAnimation();
                              },
                              child: Container(
                                height: 30,
                                width: 100,
                                color: Colors.red,
                                child: Text("点击开始动画"),
                              ),
                            )),
                      ],
                    )),
              )),
          Transform.translate(
            offset: Offset(0, -36),
            child: Container(
                height: 100, width: double.infinity, color: Colors.blue),
          ),
        ],
      ),
    );
  }
}
