/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vi;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.baidu.mapsdkplatform.comapi.util.SyncSysInfo;
import com.baidu.platform.comapi.util.NetworkUtil;
import com.baidu.platform.comapi.util.SysOSUtil;
import com.baidu.vi.VIContext;
import com.baidu.vi.VNetworkInfo;
import com.baidu.vi.f;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class VDeviceAPI {
    private static PowerManager.WakeLock a = null;
    private static BroadcastReceiver b = null;

    public static long getTotalSpace() {
        File root = Environment.getRootDirectory();
        StatFs sf = new StatFs(root.getPath());
        long blockSize = sf.getBlockSize();
        long blockCount = sf.getBlockCount();
        return blockSize * blockCount / 1024L;
    }

    public static long getFreeSpace() {
        File root = Environment.getRootDirectory();
        StatFs sf = new StatFs(root.getPath());
        long blockSize = sf.getBlockSize();
        long availCount = sf.getAvailableBlocks();
        return blockSize * availCount / 1024L;
    }

    public static long getSdcardTotalSpace() {
        File sdcardDir = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(sdcardDir.getPath());
        long blockSize = sf.getBlockSize();
        long blockCount = sf.getBlockCount();
        return blockSize * blockCount / 1024L;
    }

    public static long getSdcardFreeSpace() {
        File sdcardDir = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(sdcardDir.getPath());
        long blockSize = sf.getBlockSize();
        long availCount = sf.getAvailableBlocks();
        return blockSize * availCount / 1024L;
    }

    public static long getTotalMemory() {
        String str1 = "/proc/meminfo";
        long initialMemory = 0L;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            if (str2 != null) {
                String[] arrayOfString = str2.split("\\s+");
                initialMemory = Integer.valueOf(arrayOfString[1]).intValue();
            }
            localBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return initialMemory;
    }

    public static long getAvailableMemory() {
        ActivityManager am2 = (ActivityManager)VIContext.getContext().getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am2.getMemoryInfo(mi);
        return mi.availMem / 1024L;
    }

    public static String getOsVersion() {
        return "android";
    }

    public static String getModuleFileName() {
        return VIContext.getContext().getFilesDir().getAbsolutePath();
    }

    public static String getSdcardPath() {
        return SysOSUtil.getInstance().getCompatibleSdcardPath();
    }

    public static String getCachePath() {
        return Environment.getDataDirectory().getAbsolutePath();
    }

    public static String getAppVersion() {
        String name = VIContext.getContext().getApplicationInfo().packageName;
        try {
            return VIContext.getContext().getPackageManager().getPackageInfo((String)name, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e2) {
            return "";
        }
    }

    public static int getCurrentNetworkType() {
        int netType = -1;
        try {
            netType = Integer.parseInt(NetworkUtil.getCurrentNetMode(VIContext.getContext()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return netType;
    }

    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)VIContext.getContext().getSystemService("connectivity");
        NetworkInfo info = cm.getNetworkInfo(1);
        return info != null && info.isConnected();
    }

    public static VNetworkInfo getNetworkInfo(int type) {
        ConnectivityManager cm = (ConnectivityManager)VIContext.getContext().getSystemService("connectivity");
        NetworkInfo info = null;
        switch (type) {
            case 2: {
                info = cm.getNetworkInfo(1);
                break;
            }
            case 3: {
                info = cm.getNetworkInfo(0);
                break;
            }
        }
        if (info != null) {
            return new VNetworkInfo(info);
        }
        return null;
    }

    @Deprecated
    public static int getTelecomInfo() {
        return -1;
    }

    public static void setNetworkChangedCallback() {
        VDeviceAPI.unsetNetworkChangedCallback();
        b = new f();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        VIContext.getContext().registerReceiver(b, filter);
    }

    public static void unsetNetworkChangedCallback() {
        if (b != null) {
            VIContext.getContext().unregisterReceiver(b);
            b = null;
        }
    }

    public static native void onNetworkStateChanged();

    public static ScanResult[] getWifiHotpot() {
        return null;
    }

    public static float getSystemMetricsX() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)VIContext.getContext().getSystemService("window");
        if (wmgr != null) {
            wmgr.getDefaultDisplay().getMetrics(metrics);
        }
        return metrics.widthPixels;
    }

    public static float getSystemMetricsY() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)VIContext.getContext().getSystemService("window");
        if (wmgr != null) {
            wmgr.getDefaultDisplay().getMetrics(metrics);
        }
        return metrics.heightPixels;
    }

    public static float getScreenDensity() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)VIContext.getContext().getSystemService("window");
        if (wmgr != null) {
            wmgr.getDefaultDisplay().getMetrics(metrics);
        }
        return metrics.density;
    }

    public static int getScreenDensityDpi() {
        if (VIContext.getContext() == null) {
            return 0;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)VIContext.getContext().getSystemService("window");
        if (wmgr != null && wmgr.getDefaultDisplay() != null) {
            wmgr.getDefaultDisplay().getMetrics(metrics);
        }
        return metrics.densityDpi;
    }

    public static void setScreenAlwaysOn(boolean setValue) {
    }

    @TargetApi(value=8)
    public static int getScreenBrightness() {
        ContentResolver cr = VIContext.getContext().getContentResolver();
        int brightnessmode = 0;
        if (8 <= Build.VERSION.SDK_INT) {
            try {
                brightnessmode = Settings.System.getInt((ContentResolver)cr, (String)"screen_brightness_mode");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (brightnessmode == 1) {
            return -1;
        }
        String brightness = "screen_brightness";
        int value = 0;
        try {
            value = Settings.System.getInt((ContentResolver)cr, (String)brightness);
        }
        catch (Settings.SettingNotFoundException e2) {
            return -1;
        }
        return value;
    }

    public static void makeCall(String number) {
    }

    public static void sendSMS(String number, String content) {
    }

    public static int sendMMS(String number, String subject, String content, String extFile) {
        return 0;
    }

    public static void openUrl(String url) {
        Intent i2 = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        VIContext.getContext().startActivity(i2);
    }

    public static String getCellId() {
        return "";
    }

    public static String getLac() {
        return "";
    }

    public static String getImei() {
        return null;
    }

    public static String getImsi() {
        TelephonyManager manager = (TelephonyManager)VIContext.getContext().getSystemService("phone");
        if (manager != null) {
            // empty if block
        }
        return null;
    }

    public static String getCuid() {
        return SyncSysInfo.getCid();
    }
}

