/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vi;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.SparseArray;
import com.baidu.vi.c;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class EnvDrawText {
    private static final int FONT_STYLE_NORMAL = 0;
    private static final int FONT_STYLE_BOLD = 1;
    private static final int FONT_STYLE_ITALIC = 2;
    private static final String DEVICE_VIVOX3L = "vivo X3L";
    private static Bitmap defaultFontBmp = null;
    private static Context mContext = null;
    public static SparseArray<c> fontCache = null;
    private static String phonetype = null;

    public static void setContext(Context context) {
        mContext = context;
    }

    private static Typeface getTypeface(int iFontStyle) {
        Typeface font = Typeface.DEFAULT;
        switch (iFontStyle) {
            case 1: {
                font = Typeface.DEFAULT_BOLD;
                break;
            }
            case 2: {
                font = Typeface.create((Typeface)Typeface.DEFAULT, (int)2);
                break;
            }
            default: {
                font = Typeface.DEFAULT;
            }
        }
        return font;
    }

    private static Bitmap getTextBitmap() {
        Paint paint = new Paint();
        paint.setSubpixelText(true);
        paint.setAntiAlias(false);
        paint.setTextSize(12.0f);
        Typeface fontCurrent = Typeface.DEFAULT;
        paint.setTypeface(fontCurrent);
        String text = "!";
        float width = paint.measureText(text);
        float height = paint.descent() - paint.ascent();
        if (width <= 0.0f) {
            width = 3.0f;
        }
        if (height <= 0.0f) {
            height = 15.0f;
        }
        Bitmap bmp = Bitmap.createBitmap((int)((int)Math.ceil(width)), (int)((int)Math.ceil(height)), (Bitmap.Config)Bitmap.Config.ALPHA_8);
        bmp.eraseColor(0);
        Canvas canvasTemp = new Canvas();
        canvasTemp.setBitmap(bmp);
        canvasTemp.drawText(text, 0.0f, 0.0f - paint.ascent(), paint);
        return bmp;
    }

    private static native boolean nativeIsBitmapSame(Bitmap var0, Bitmap var1);

    private static synchronized boolean isSystemFontChanged() {
        boolean bChange;
        if (defaultFontBmp == null) {
            defaultFontBmp = EnvDrawText.getTextBitmap();
            return false;
        }
        Bitmap bmpFontCurrent = EnvDrawText.getTextBitmap();
        boolean bl = bChange = !EnvDrawText.nativeIsBitmapSame(bmpFontCurrent, defaultFontBmp);
        if (bChange) {
            defaultFontBmp.recycle();
            defaultFontBmp = Bitmap.createBitmap((Bitmap)bmpFontCurrent);
            bmpFontCurrent.recycle();
            return true;
        }
        bmpFontCurrent.recycle();
        return false;
    }

    private static Paint.Align getTextAlignedType(int nTextPos) {
        if (1 == nTextPos) {
            return Paint.Align.LEFT;
        }
        if (2 == nTextPos) {
            return Paint.Align.RIGHT;
        }
        return Paint.Align.CENTER;
    }

    private static synchronized int[] drawText(String mstr, int iFontSize, int iFontStyle, int[] iParam, int txtrgb, int srgb, int colorbg, int iHaloWidth, int iTextPos) {
        int iPos;
        int iWordHight = 0;
        int iWordWidth = 0;
        int iWordWidthMax = 0;
        int iWordHightMax = 0;
        Bitmap bmp = null;
        Canvas canvasTemp = new Canvas();
        TextPaint pt = new TextPaint();
        if (canvasTemp == null || pt == null) {
            return new int[0];
        }
        if (TextUtils.isEmpty((CharSequence)phonetype)) {
            phonetype = Build.MODEL;
        }
        if (phonetype != null && phonetype.equals(DEVICE_VIVOX3L)) {
            iFontStyle = 0;
        }
        pt.reset();
        pt.setSubpixelText(true);
        pt.setAntiAlias(true);
        pt.setTextSize((float)iFontSize);
        pt.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        pt.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        if (iHaloWidth != 0) {
            pt.setStrokeWidth((float)iHaloWidth);
            pt.setStrokeCap(Paint.Cap.ROUND);
            pt.setStrokeJoin(Paint.Join.ROUND);
            pt.setStyle(Paint.Style.STROKE);
        }
        if ((iPos = mstr.indexOf(92, 0)) == -1) {
            Paint.FontMetrics fm = pt.getFontMetrics();
            iWordWidth = (int)((double)Layout.getDesiredWidth((CharSequence)mstr, (int)0, (int)mstr.length(), (TextPaint)pt) + 0.5);
            iWordHight = (int)Math.ceil(fm.descent - fm.ascent);
            iParam[0] = iWordWidth;
            iParam[1] = iWordHight;
            if (iParam.length == 4) {
                int level = (int)Math.ceil(Math.log(iWordWidth) / Math.log(2.0));
                iWordWidth = (int)Math.pow(2.0, level);
                level = (int)Math.ceil(Math.log(iWordHight) / Math.log(2.0));
                iWordHight = (int)Math.pow(2.0, level);
            }
            if (iWordWidthMax != iWordWidth || iWordHightMax != iWordHight) {
                iWordWidthMax = iWordWidth;
                iWordHightMax = iWordHight;
            }
            if (iParam.length == 4) {
                iParam[2] = iWordWidthMax;
                iParam[3] = iWordHightMax;
            }
            if (iWordWidthMax > 0 && iWordHightMax > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidthMax, (int)iWordHightMax, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (bmp == null) {
                    return new int[0];
                }
                canvasTemp.setBitmap(bmp);
            }
            if ((colorbg & 0xFF000000) == 0) {
                canvasTemp.drawColor(0xFFFFFF);
            } else {
                canvasTemp.drawColor(colorbg);
            }
            if (iHaloWidth != 0 && canvasTemp != null) {
                pt.setStrokeWidth((float)iHaloWidth);
                pt.setStrokeCap(Paint.Cap.ROUND);
                pt.setStrokeJoin(Paint.Join.ROUND);
                pt.setStyle(Paint.Style.STROKE);
                pt.setColor(srgb);
                canvasTemp.drawText(mstr, 0.0f, 0.0f - fm.ascent, (Paint)pt);
            }
            pt.setStyle(Paint.Style.FILL);
            pt.setColor(txtrgb);
            canvasTemp.drawText(mstr, 0.0f, 0.0f - fm.ascent, (Paint)pt);
        } else {
            String strTxt;
            int iPosTmp = iPos + 1;
            int iRow = 2;
            int iMax = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(0, iPos), (TextPaint)pt) + 0.5);
            int iMaxTmp = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, iPos), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
                iPosTmp = iPos + 1;
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, mstr.length()), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
            }
            Paint.FontMetrics fm = pt.getFontMetrics();
            int iRowHeight = (int)Math.ceil(fm.descent - fm.ascent);
            iWordWidth = iMax;
            iWordHight = iRowHeight * iRow;
            iParam[0] = iWordWidth;
            iParam[1] = iWordHight;
            if (iParam.length == 4) {
                int level = (int)Math.ceil(Math.log(iWordWidth) / Math.log(2.0));
                iWordWidth = (int)Math.pow(2.0, level);
                level = (int)Math.ceil(Math.log(iWordHight) / Math.log(2.0));
                iWordHight = (int)Math.pow(2.0, level);
            }
            if (iWordWidthMax != iWordWidth || iWordHightMax != iWordHight) {
                iWordWidthMax = iWordWidth;
                iWordHightMax = iWordHight;
            }
            if (iParam.length == 4) {
                iParam[2] = iWordWidthMax;
                iParam[3] = iWordHightMax;
            }
            if (iWordWidthMax > 0 && iWordHightMax > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidthMax, (int)iWordHightMax, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (bmp == null) {
                    return new int[0];
                }
                canvasTemp.setBitmap(bmp);
            }
            if ((colorbg & 0xFF000000) == 0) {
                canvasTemp.drawColor(0xFFFFFF);
            } else {
                canvasTemp.drawColor(colorbg);
            }
            pt.setTextAlign(EnvDrawText.getTextAlignedType(iTextPos));
            int nStartX = 0;
            nStartX = iTextPos == 1 ? 0 : (iTextPos == 2 ? iParam[0] : iParam[0] / 2);
            iPos = 0;
            iPosTmp = 0;
            iRow = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                strTxt = mstr.substring(iPosTmp, iPos);
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                iPosTmp = iPos + 1;
                if (iHaloWidth != 0 && canvasTemp != null) {
                    pt.setStrokeWidth((float)iHaloWidth);
                    pt.setStrokeCap(Paint.Cap.ROUND);
                    pt.setStrokeJoin(Paint.Join.ROUND);
                    pt.setStyle(Paint.Style.STROKE);
                    pt.setColor(srgb);
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                pt.setStyle(Paint.Style.FILL);
                pt.setColor(txtrgb);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                strTxt = mstr.substring(iPosTmp, mstr.length());
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                if (iHaloWidth != 0 && canvasTemp != null) {
                    pt.setStrokeWidth((float)iHaloWidth);
                    pt.setStrokeCap(Paint.Cap.ROUND);
                    pt.setStrokeJoin(Paint.Join.ROUND);
                    pt.setStyle(Paint.Style.STROKE);
                    pt.setColor(srgb);
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                pt.setStyle(Paint.Style.FILL);
                pt.setColor(txtrgb);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
            }
        }
        int iSizedata = iWordWidthMax * iWordHightMax;
        int[] buffer = new int[iSizedata];
        if (bmp != null) {
            IntBuffer wrapBuffer = IntBuffer.wrap(buffer);
            bmp.copyPixelsToBuffer((Buffer)wrapBuffer);
        }
        if (bmp != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        return buffer;
    }

    private static synchronized Bitmap drawTextExt(String mstr, int iFontSize, int iFontStyle, int[] iParam, int txtrgb, int srgb, int colorbg, int iHaloWidth, int iAlignedType) {
        int iPos;
        int iWordHight = 0;
        int iWordWidth = 0;
        int iWordWidthMax = 0;
        int iWordHightMax = 0;
        Bitmap bmp = null;
        Canvas canvasTemp = new Canvas();
        TextPaint pt = new TextPaint();
        if (canvasTemp == null || pt == null) {
            return bmp;
        }
        if (TextUtils.isEmpty((CharSequence)phonetype)) {
            phonetype = Build.MODEL;
        }
        if (phonetype != null && phonetype.equals(DEVICE_VIVOX3L)) {
            iFontStyle = 0;
        }
        pt.reset();
        pt.setSubpixelText(true);
        pt.setAntiAlias(true);
        pt.setTextSize((float)iFontSize);
        pt.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        pt.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        if (iHaloWidth != 0) {
            pt.setStrokeWidth((float)iHaloWidth);
            pt.setStrokeCap(Paint.Cap.ROUND);
            pt.setStrokeJoin(Paint.Join.ROUND);
            pt.setStyle(Paint.Style.STROKE);
        }
        if ((iPos = mstr.indexOf(92, 0)) == -1) {
            Paint.FontMetrics fm = pt.getFontMetrics();
            iWordWidth = (int)((double)Layout.getDesiredWidth((CharSequence)mstr, (int)0, (int)mstr.length(), (TextPaint)pt) + 0.5);
            iWordHight = (int)Math.ceil(fm.descent - fm.ascent);
            iParam[0] = iWordWidth;
            iParam[1] = iWordHight;
            if (iParam.length == 4) {
                int level = (int)Math.ceil(Math.log(iWordWidth) / Math.log(2.0));
                iWordWidth = (int)Math.pow(2.0, level);
                level = (int)Math.ceil(Math.log(iWordHight) / Math.log(2.0));
                iWordHight = (int)Math.pow(2.0, level);
            }
            if (iWordWidthMax != iWordWidth || iWordHightMax != iWordHight) {
                iWordWidthMax = iWordWidth;
                iWordHightMax = iWordHight;
            }
            if (iParam.length == 4) {
                iParam[2] = iWordWidthMax;
                iParam[3] = iWordHightMax;
            }
            if (iWordWidthMax > 0 && iWordHightMax > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidthMax, (int)iWordHightMax, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (bmp == null) {
                    return bmp;
                }
                canvasTemp.setBitmap(bmp);
            }
            if ((colorbg & 0xFF000000) == 0) {
                canvasTemp.drawColor(0xFFFFFF);
            } else {
                canvasTemp.drawColor(colorbg);
            }
            if (iHaloWidth != 0 && canvasTemp != null) {
                pt.setStrokeWidth((float)iHaloWidth);
                pt.setStrokeCap(Paint.Cap.ROUND);
                pt.setStrokeJoin(Paint.Join.ROUND);
                pt.setStyle(Paint.Style.STROKE);
                pt.setColor(srgb);
                canvasTemp.drawText(mstr, 0.0f, 0.0f - fm.ascent, (Paint)pt);
            }
            pt.setStyle(Paint.Style.FILL);
            pt.setColor(txtrgb);
            canvasTemp.drawText(mstr, 0.0f, 0.0f - fm.ascent, (Paint)pt);
        } else {
            String strTxt;
            int iPosTmp = iPos + 1;
            int iRow = 2;
            int iMax = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(0, iPos), (TextPaint)pt) + 0.5);
            int iMaxTmp = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, iPos), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
                iPosTmp = iPos + 1;
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, mstr.length()), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
            }
            Paint.FontMetrics fm = pt.getFontMetrics();
            int iRowHeight = (int)Math.ceil(fm.descent - fm.ascent);
            iWordWidth = iMax;
            iWordHight = iRowHeight * iRow;
            iParam[0] = iWordWidth;
            iParam[1] = iWordHight;
            if (iParam.length == 4) {
                int level = (int)Math.ceil(Math.log(iWordWidth) / Math.log(2.0));
                iWordWidth = (int)Math.pow(2.0, level);
                level = (int)Math.ceil(Math.log(iWordHight) / Math.log(2.0));
                iWordHight = (int)Math.pow(2.0, level);
            }
            if (iWordWidthMax != iWordWidth || iWordHightMax != iWordHight) {
                iWordWidthMax = iWordWidth;
                iWordHightMax = iWordHight;
            }
            if (iParam.length == 4) {
                iParam[2] = iWordWidthMax;
                iParam[3] = iWordHightMax;
            }
            if (iWordWidthMax > 0 && iWordHightMax > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidthMax, (int)iWordHightMax, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (bmp == null) {
                    return bmp;
                }
                canvasTemp.setBitmap(bmp);
            }
            if ((colorbg & 0xFF000000) == 0) {
                canvasTemp.drawColor(0xFFFFFF);
            } else {
                canvasTemp.drawColor(colorbg);
            }
            pt.setTextAlign(EnvDrawText.getTextAlignedType(iAlignedType));
            int nStartX = 0;
            nStartX = iAlignedType == 1 ? 0 : (iAlignedType == 2 ? iParam[0] : iParam[0] / 2);
            iPos = 0;
            iPosTmp = 0;
            iRow = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                strTxt = mstr.substring(iPosTmp, iPos);
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                iPosTmp = iPos + 1;
                if (iHaloWidth != 0 && canvasTemp != null) {
                    pt.setStrokeWidth((float)iHaloWidth);
                    pt.setStrokeCap(Paint.Cap.ROUND);
                    pt.setStrokeJoin(Paint.Join.ROUND);
                    pt.setStyle(Paint.Style.STROKE);
                    pt.setColor(srgb);
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                pt.setStyle(Paint.Style.FILL);
                pt.setColor(txtrgb);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                strTxt = mstr.substring(iPosTmp, mstr.length());
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                if (iHaloWidth != 0 && canvasTemp != null) {
                    pt.setStrokeWidth((float)iHaloWidth);
                    pt.setStrokeCap(Paint.Cap.ROUND);
                    pt.setStrokeJoin(Paint.Join.ROUND);
                    pt.setStyle(Paint.Style.STROKE);
                    pt.setColor(srgb);
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                pt.setStyle(Paint.Style.FILL);
                pt.setColor(txtrgb);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, (float)nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
            }
        }
        return bmp;
    }

    private static short[] getTextSize(String mstr, int iFontSize, int iFontStyle) {
        int iLen = mstr.length();
        if (iLen == 0) {
            return null;
        }
        TextPaint pt = new TextPaint();
        pt.setSubpixelText(true);
        pt.setAntiAlias(true);
        pt.setTextSize((float)iFontSize);
        pt.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        short charWidthTmp = 0;
        short[] buf = new short[iLen];
        for (int i2 = 0; i2 < iLen; ++i2) {
            buf[i2] = charWidthTmp = (short)((double)Layout.getDesiredWidth((CharSequence)mstr, (int)0, (int)(i2 + 1), (TextPaint)pt) + 0.5);
        }
        return buf;
    }

    private static short[] getTextSizeWithHalo(String mstr, int iFontSize, int iFontStyle, int iHaloWidth) {
        int iLen = mstr.length();
        if (iLen == 0) {
            return null;
        }
        TextPaint pt = new TextPaint();
        pt.setSubpixelText(true);
        pt.setAntiAlias(true);
        pt.setTextSize((float)iFontSize);
        pt.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        if (iHaloWidth != 0) {
            pt.setStrokeWidth((float)iHaloWidth);
            pt.setStrokeCap(Paint.Cap.ROUND);
            pt.setStrokeJoin(Paint.Join.ROUND);
            pt.setStyle(Paint.Style.STROKE);
        }
        short charWidthTmp = 0;
        short[] buf = new short[iLen];
        for (int i2 = 0; i2 < iLen; ++i2) {
            buf[i2] = charWidthTmp = (short)((double)Layout.getDesiredWidth((CharSequence)mstr, (int)0, (int)(i2 + 1), (TextPaint)pt) + 0.5);
        }
        return buf;
    }

    private static float[] getTextSizeExt(String mstr, int iFontSize, int iFontStyle) {
        int iLen = mstr.length();
        if (iLen == 0) {
            return null;
        }
        Paint paint = new Paint();
        paint.setSubpixelText(true);
        paint.setAntiAlias(true);
        paint.setTextSize((float)iFontSize);
        paint.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        float[] buffer = new float[]{paint.measureText(mstr), paint.descent() - paint.ascent()};
        return buffer;
    }

    private static Bitmap drawTextAlpha(String mstr, int iFontSize, int iFontStyle, int iHaloWidth) {
        int iWordHight = 0;
        int iWordWidth = 0;
        Bitmap bmp = null;
        Canvas canvasTemp = new Canvas();
        TextPaint pt = new TextPaint();
        if (canvasTemp == null || pt == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)phonetype)) {
            phonetype = Build.MODEL;
        }
        if (phonetype != null && phonetype.equals(DEVICE_VIVOX3L)) {
            iFontStyle = 0;
        }
        pt.reset();
        pt.setSubpixelText(false);
        pt.setAntiAlias(false);
        pt.setTextSize((float)iFontSize);
        pt.setTypeface(EnvDrawText.getTypeface(iFontStyle));
        float fHaloWidth = (float)iHaloWidth * 1.3f + 0.5f;
        int iPos = mstr.indexOf(92, 0);
        if (iPos == -1) {
            Paint.FontMetrics fm = pt.getFontMetrics();
            iWordWidth = (int)(Layout.getDesiredWidth((CharSequence)mstr, (int)0, (int)mstr.length(), (TextPaint)pt) + fHaloWidth);
            iWordHight = (int)Math.ceil(fm.descent - fm.ascent);
            if (iWordWidth > 0 && iWordHight > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidth, (int)iWordHight, (Bitmap.Config)Bitmap.Config.ALPHA_8);
                if (bmp == null) {
                    return bmp;
                }
                bmp.eraseColor(0);
                canvasTemp.setBitmap(bmp);
            }
            pt.setStyle(Paint.Style.FILL);
            canvasTemp.drawText(mstr, fHaloWidth * 0.5f, 0.0f - fm.ascent, (Paint)pt);
        } else {
            String strTxt;
            int iPosTmp = iPos + 1;
            int iRow = 2;
            int iMax = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(0, iPos), (TextPaint)pt) + 0.5);
            int iMaxTmp = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, iPos), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
                iPosTmp = iPos + 1;
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                iMaxTmp = (int)((double)Layout.getDesiredWidth((CharSequence)mstr.substring(iPosTmp, mstr.length()), (TextPaint)pt) + 0.5);
                iMax = iMaxTmp > iMax ? iMaxTmp : iMax;
            }
            Paint.FontMetrics fm = pt.getFontMetrics();
            int iRowHeight = (int)Math.ceil(fm.descent - fm.ascent);
            iWordWidth = iMax + iHaloWidth;
            iWordHight = iRowHeight * iRow;
            if (iWordWidth > 0 && iWordHight > 0) {
                bmp = Bitmap.createBitmap((int)iWordWidth, (int)iWordHight, (Bitmap.Config)Bitmap.Config.ALPHA_8);
                if (bmp == null) {
                    return bmp;
                }
                bmp.eraseColor(0);
                canvasTemp.setBitmap(bmp);
            }
            int nTextPos = 3;
            pt.setTextAlign(EnvDrawText.getTextAlignedType(nTextPos));
            float nStartX = 0.0f;
            nStartX = nTextPos == 1 ? fHaloWidth * 0.5f : (nTextPos == 3 ? (float)iWordWidth - fHaloWidth * 0.5f : (float)(iWordWidth / 2) + fHaloWidth * 0.5f);
            iPos = 0;
            iPosTmp = 0;
            iRow = 0;
            while ((iPos = mstr.indexOf(92, iPosTmp)) > 0) {
                strTxt = mstr.substring(iPosTmp, iPos);
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                iPosTmp = iPos + 1;
                pt.setStyle(Paint.Style.FILL);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
                ++iRow;
            }
            if (iPosTmp != mstr.length()) {
                strTxt = mstr.substring(iPosTmp, mstr.length());
                iMax = (int)((double)Layout.getDesiredWidth((CharSequence)strTxt, (TextPaint)pt) + 0.5);
                pt.setStyle(Paint.Style.FILL);
                if (canvasTemp != null) {
                    canvasTemp.drawText(strTxt, nStartX, (float)(iRow * iRowHeight) - fm.ascent, (Paint)pt);
                }
            }
        }
        return bmp;
    }

    public static synchronized void registFontCache(int fontHashValue, Typeface typeface) {
        c cache;
        if (fontHashValue == 0 || typeface == null) {
            return;
        }
        if (fontCache == null) {
            fontCache = new SparseArray();
        }
        if ((cache = (c)fontCache.get(fontHashValue)) == null) {
            c newCache = new c();
            newCache.a = typeface;
            ++newCache.b;
            fontCache.put(fontHashValue, (Object)newCache);
        } else {
            ++cache.b;
        }
    }

    public static synchronized void removeFontCache(int fontHashValue) {
        c cache = (c)fontCache.get(fontHashValue);
        if (cache == null) {
            return;
        }
        --cache.b;
        if (cache.b == 0) {
            fontCache.remove(fontHashValue);
        }
    }
}

