/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.baidu.platform.comapi.util.l;

public class NetworkUtil {
    public static final int NETYPE_NOCON = -1;
    public static final int NETYPE_UNKNOWN = 0;
    public static final int NETYPE_WIFI = 1;
    public static final int NETYPE_2G = 2;
    public static final int NETYPE_3G = 3;
    public static final int NETYPE_4G = 4;
    public static final int NETYPE_TELECOM_2G = 5;
    public static final int NETYPE_MOBILE_UNICOM_2G = 6;
    public static final int NETYPE_TELECOM_3G = 7;
    public static final int NETYPE_MOBILE_3G = 8;
    public static final int NETYPE_UNICOM_3G = 9;
    public static final int NETYPE_4G_UNKNOWN = 10;
    public static boolean mUseProxy = false;
    public static String mProxyHost = "";
    public static int mProxyPort = 0;

    public static void updateNetworkProxy(Context context) {
    }

    public static boolean initConnectState() {
        return true;
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            if (manager != null) {
                return manager.getActiveNetworkInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static NetworkInfo[] getAllNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] networkInfos = null;
        try {
            networkInfos = manager.getAllNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkInfos;
    }

    @SuppressLint(value={"NewApi"})
    public static void registerNetwork(Context context) {
        if (null == context) {
            return;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkRequest.Builder builder = new NetworkRequest.Builder();
        NetworkRequest request = builder.build();
        if (null != manager) {
            l mNetworkCallback = new l();
            manager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)mNetworkCallback);
        }
    }

    public static String getCurrentNetMode(Context context) {
        int netType = -1;
        NetworkInfo info = NetworkUtil.getActiveNetworkInfo(context);
        if (null != info) {
            int conType = info.getType();
            if (conType == 1) {
                netType = 1;
            } else if (conType == 0 || conType == 3 || conType == 4 || conType == 5) {
                if (Build.VERSION.SDK_INT > 29) {
                    String networkType = "mobile";
                    ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (manager == null) {
                        return networkType;
                    }
                    Network network = manager.getActiveNetwork();
                    NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(network);
                    return NetworkUtil.a(networkCapabilities);
                }
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm != null) {
                    int type = tm.getNetworkType();
                    switch (type) {
                        case 7: 
                        case 11: 
                        case 16: {
                            netType = 2;
                            break;
                        }
                        case 13: 
                        case 18: {
                            netType = 4;
                            break;
                        }
                        case 4: {
                            netType = 5;
                            break;
                        }
                        case 1: 
                        case 2: {
                            netType = 6;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 12: {
                            netType = 7;
                            break;
                        }
                        case 8: 
                        case 17: {
                            netType = 8;
                            break;
                        }
                        case 3: 
                        case 9: 
                        case 10: 
                        case 15: {
                            netType = 9;
                            break;
                        }
                        case 14: {
                            netType = 3;
                            break;
                        }
                        default: {
                            netType = 0;
                        }
                    }
                }
            }
        } else {
            netType = -1;
        }
        return Integer.toString(netType);
    }

    @SuppressLint(value={"NewApi"})
    private static String a(NetworkCapabilities networkCapabilities) {
        String networkType = "mobile";
        if (networkCapabilities == null) {
            return networkType;
        }
        boolean hasTransportWifi = networkCapabilities.hasTransport(1);
        boolean hasTransportCellular = networkCapabilities.hasTransport(0);
        boolean hasTransportEthernet = networkCapabilities.hasTransport(3);
        boolean hasTransportLoWPAN = networkCapabilities.hasTransport(6);
        boolean hasTransportVPN = networkCapabilities.hasTransport(4);
        boolean hasTransportWifiAware = networkCapabilities.hasTransport(5);
        if (hasTransportWifi) {
            networkType = "WIFI";
        } else if (hasTransportCellular) {
            networkType = "CELLULAR";
        } else if (hasTransportEthernet) {
            networkType = "ETHERNET";
        } else if (hasTransportLoWPAN) {
            networkType = "LoWPAN";
        } else if (hasTransportVPN) {
            networkType = "VPN";
        } else if (hasTransportWifiAware) {
            networkType = "WifiAware";
        }
        return networkType;
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            if (NetworkUtil.isWifiConnected(context)) {
                return true;
            }
            ConnectivityManager cManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cManager.getActiveNetworkInfo();
            return info != null && info.isConnectedOrConnecting();
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean isWifiConnected(Context context) {
        if (context == null) {
            return false;
        }
        boolean isWifiConnected = false;
        try {
            NetworkInfo activeNetInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (activeNetInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                isWifiConnected = 1 == activeNetInfo.getType() && activeNetInfo.isConnected();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isWifiConnected;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifiState(Context context) {
        if (context == null) {
            return false;
        }
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        int wifiState = 1;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                if (0 == context.checkSelfPermission("android.permission.ACCESS_WIFI_STATE")) {
                    wifiState = wifiManager.getWifiState();
                }
            } else {
                wifiState = wifiManager.getWifiState();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wifiState == 3;
    }

    public static String getNetworkOperatorInfo(Context context) {
        String mccmnc;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null && !TextUtils.isEmpty((CharSequence)(mccmnc = telephonyManager.getNetworkOperator()))) {
            try {
                StringBuilder stringBuilder = new StringBuilder(mccmnc);
                stringBuilder.insert(3, ":");
                return stringBuilder.toString();
            }
            catch (Exception e2) {
                return "";
            }
        }
        return "";
    }

    public static int getNetworkOperatorType(Context context) {
        String mcc_mnc = NetworkUtil.getNetworkOperatorInfo(context);
        if (!TextUtils.isEmpty((CharSequence)mcc_mnc)) {
            if (mcc_mnc.startsWith("460:00") || mcc_mnc.startsWith("460:02")) {
                return 0;
            }
            if (mcc_mnc.startsWith("460:01")) {
                return 1;
            }
            if (mcc_mnc.startsWith("460:03")) {
                return 2;
            }
        }
        return -1;
    }
}

