/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comapi.map.Projection;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import org.json.JSONException;
import org.json.JSONObject;

class k
implements Projection {
    private MapController a = null;

    public k(MapController mapController) {
        this.a = mapController;
    }

    @Override
    public GeoPoint fromPixels(int x2, int y2) {
        AppBaseMap baseMap = this.a.getBaseMap();
        if (baseMap == null) {
            return null;
        }
        String strGeoPt = baseMap.ScrPtToGeoPoint(x2, y2);
        GeoPoint geoPoint = new GeoPoint(0, 0);
        if (strGeoPt != null) {
            try {
                JSONObject jsonObj = new JSONObject(strGeoPt);
                geoPoint.setLongitude(jsonObj.getDouble("geox"));
                geoPoint.setLatitude(jsonObj.getDouble("geoy"));
                return geoPoint;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public float metersToEquatorPixels(float meters) {
        return (float)((double)meters / this.a.getZoomUnitsInMeter());
    }

    @Override
    public Point toPixels(GeoPoint in, Point out) {
        AppBaseMap baseMap;
        if (out == null) {
            out = new Point(0, 0);
        }
        if ((baseMap = this.a.getBaseMap()) == null) {
            return out;
        }
        String strScrPt = baseMap.GeoPtToScrPoint((int)in.getLongitude(), (int)in.getLatitude());
        if (strScrPt != null) {
            try {
                JSONObject jsonObj = new JSONObject(strScrPt);
                out.setIntX(jsonObj.getInt("scrx"));
                out.setIntY(jsonObj.getInt("scry"));
                jsonObj = null;
                strScrPt = null;
                return out;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return out;
    }

    @Override
    public Point toPixels(GeoPoint in, int height, Point out) {
        AppBaseMap baseMap;
        if (out == null) {
            out = new Point(0, 0);
        }
        if ((baseMap = this.a.getBaseMap()) == null) {
            return out;
        }
        String strScrPt = baseMap.geoPt3ToScrPoint((int)in.getLongitude(), (int)in.getLatitude(), height);
        if (strScrPt != null) {
            try {
                JSONObject jsonObj = new JSONObject(strScrPt);
                out.setIntX(jsonObj.getInt("scrx"));
                out.setIntY(jsonObj.getInt("scry"));
                return out;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return out;
    }

    @Override
    public Point world2Screen(float x2, float y2, float z2) {
        Point out = new Point(0, 0);
        AppBaseMap baseMap = this.a.getBaseMap();
        if (baseMap == null) {
            return out;
        }
        String strScrPt = baseMap.worldPointToScreenPoint(x2, y2, z2);
        if (strScrPt != null) {
            try {
                JSONObject jsonObj = new JSONObject(strScrPt);
                out.setDoubleX(jsonObj.optDouble("scrx"));
                out.setDoubleY(jsonObj.optDouble("scry"));
                return out;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }
}

