/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.baidu.mapapi.OpenLogUtil;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.MapBound;
import com.baidu.platform.comapi.bmsdk.BmLayer;
import com.baidu.platform.comapi.map.GLTextureView;
import com.baidu.platform.comapi.map.IndoorMapInfo;
import com.baidu.platform.comapi.map.InnerOverlay;
import com.baidu.platform.comapi.map.ItemizedOverlay;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comapi.map.MapRenderModeChangeListener;
import com.baidu.platform.comapi.map.MapStatus;
import com.baidu.platform.comapi.map.MapViewInterface;
import com.baidu.platform.comapi.map.Overlay;
import com.baidu.platform.comapi.map.Projection;
import com.baidu.platform.comapi.map.ab;
import com.baidu.platform.comapi.map.ae;
import com.baidu.platform.comapi.map.aj;
import com.baidu.platform.comapi.map.ak;
import com.baidu.platform.comapi.map.am;
import com.baidu.platform.comapi.map.k;
import com.baidu.platform.comapi.map.o;
import com.baidu.platform.comapi.map.x;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class MapTextureView
extends GLTextureView
implements GestureDetector.OnDoubleTapListener,
GestureDetector.OnGestureListener,
MapRenderModeChangeListener,
MapViewInterface,
aj {
    protected com.baidu.mapsdkplatform.comapi.map.c mBaseMapInner;
    protected MapController mMapController = null;
    protected ae overlayMapCallBack = null;
    protected k mProjection = null;
    protected o mapRenderer = null;
    int a;
    int b;
    private List<BmLayer> c = new ArrayList<BmLayer>();
    protected List<Overlay> innerOverlayList = new ArrayList<Overlay>();
    protected ab mapRenderStableListener;
    protected am simpleGestureAdapter;
    protected GestureDetector mGestureDetector;
    private boolean d = true;
    private c e;

    public MapTextureView(Context context) {
        super(context);
        this.a(context);
    }

    public MapTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a(context);
    }

    public MapTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.a(context);
    }

    private void a(Context context) {
        this.setEGLContextClientVersion(3);
        this.simpleGestureAdapter = new am();
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.simpleGestureAdapter);
        this.simpleGestureAdapter.a(new b(null));
        if (OpenLogUtil.isMapLogEnable()) {
            com.baidu.mapsdkplatform.comapi.commonutils.b.a().a("BasicMap surfaceView initView");
        }
    }

    public void listenMapRenderMessage(c listener) {
        this.e = listener;
    }

    public void unListenMapRenderMessage() {
        this.e = null;
    }

    public void setBaseMap(com.baidu.mapsdkplatform.comapi.map.c baseMap) {
        this.mBaseMapInner = baseMap;
    }

    public com.baidu.mapsdkplatform.comapi.map.c getBaseMap() {
        return this.mBaseMapInner;
    }

    public void attachBaseMapController(MapController mapController) {
        this.mapRenderer = new o(this, (aj)this);
        this.mMapController = mapController;
        this.mapRenderer.a(mapController.getBaseMap());
        this.setEGLContextFactory(new a(null));
        this.setRenderer(this.mapRenderer);
        this.setRenderMode(0);
        this.mapRenderer.a(true);
        this.setPreserveEGLContextOnPause(true);
        this.overlayMapCallBack = new ae(this.mMapController.getBaseMap());
        this.mMapController.setOverlayMapCallBack(this.overlayMapCallBack);
        this.mMapController.setMapViewInterface(this);
        this.initInnerOverlays();
        this.mMapController.setMapRenderModeChangeListener(this);
        this.mProjection = new k(this.mMapController);
        this.simpleGestureAdapter.a(this.mMapController);
    }

    public void setMapRenderStableListener(ab listener) {
        this.mapRenderStableListener = listener;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        this.a = width;
        this.b = height;
        if (this.mMapController != null) {
            if (this.mMapController.getMapViewSurfaceListener() != null) {
                this.mMapController.getMapViewSurfaceListener().onSurfaceChanged(width, height);
            }
            MapStatus st = this.getMapStatus();
            this.a = Math.abs(st.winRound.right - st.winRound.left);
            this.b = Math.abs(st.winRound.bottom - st.winRound.top);
        }
        if (this.mBaseMapInner != null) {
            this.mBaseMapInner.a(this.a, this.b);
        }
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureSizeChanged(surface, width, height);
        this.a = width;
        this.b = height;
        this.mapRenderer.a = width;
        this.mapRenderer.b = height;
        this.mapRenderer.c = 0;
        if (this.mMapController != null) {
            MapStatus st = this.getMapStatus();
            st.winRound.left = 0;
            st.winRound.top = 0;
            st.winRound.bottom = height;
            st.winRound.right = width;
            this.mMapController.setMapStatusWithAnimation(st, 4, 0);
            if (this.mMapController.getMapViewSurfaceListener() != null) {
                this.mMapController.getMapViewSurfaceListener().onSurfaceChanged(width, height);
            }
            st = this.getMapStatus();
            int winRoundWidth = Math.abs(st.winRound.right - st.winRound.left);
            int winRoundHeight = Math.abs(st.winRound.bottom - st.winRound.top);
            if (OpenLogUtil.isMapLogEnable()) {
                com.baidu.mapsdkplatform.comapi.commonutils.b.a().a("MapTextureView winRoundWidth = " + winRoundWidth + ";winRoundHeight = " + winRoundHeight + ";mWidth = " + this.a + ";mHeight = " + this.b);
            }
            if (winRoundWidth > 0 && winRoundHeight > 0) {
                this.a = winRoundWidth;
                this.b = winRoundHeight;
            }
            this.mMapController.setScreenSize(this.a, this.b);
        }
        if (this.mBaseMapInner != null) {
            this.mBaseMapInner.a(this.a, this.b);
        }
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        super.onSurfaceTextureDestroyed(surface);
        return true;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        super.onSurfaceTextureUpdated(surface);
    }

    public void doCaptureMapView(com.baidu.platform.comapi.map.c captureMapViewListener, int width, int height, Bitmap.Config config) {
        this.mapRenderer.a(captureMapViewListener, width, height, config);
    }

    public void doCaptureMapView(com.baidu.platform.comapi.map.c captureMapViewListener, Rect rect, Bitmap.Config config) {
        if (rect != null) {
            int startX = rect.left;
            int startY = this.b < rect.bottom ? 0 : this.b - rect.bottom;
            int width = rect.width();
            int height = rect.height();
            if (startX < 0 || startY < 0 || width <= 0 || height <= 0) {
                return;
            }
            if (width > this.a) {
                width = Math.abs(rect.width()) - (rect.right - this.a);
            }
            if (height > this.b) {
                height = Math.abs(rect.height()) - (rect.bottom - this.b);
            }
            if (startX > SysOSUtil.getScreenSizeX() || startY > SysOSUtil.getScreenSizeY()) {
                return;
            }
            this.mapRenderer.a(captureMapViewListener, startX, startY, width, height, config);
        }
    }

    @Override
    public void onMapRenderModeChange(int arg) {
        if (this.e != null) {
            this.e.a(arg);
        }
        if (arg == 1) {
            this.requestRender();
        } else if (arg == 0) {
            if (this.getRenderMode() != 0) {
                this.setRenderMode(0);
            }
        } else if (arg == 2 && this.mapRenderStableListener != null) {
            this.mapRenderStableListener.a();
        }
    }

    @Override
    public void onRequestRender() {
    }

    public boolean onSingleTapConfirmed(MotionEvent e2) {
        return false;
    }

    public boolean onDoubleTap(MotionEvent e2) {
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e2) {
        return false;
    }

    public boolean onDown(MotionEvent e2) {
        return false;
    }

    public void onShowPress(MotionEvent e2) {
    }

    public boolean onSingleTapUp(MotionEvent e2) {
        return false;
    }

    public boolean onScroll(MotionEvent e12, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(MotionEvent e2) {
        block9: {
            block8: {
                if (this.mMapController == null || this.mMapController.getBaseMap() == null || !this.mMapController.mIsMapLoadFinish) {
                    return;
                }
                String s2 = this.mMapController.getBaseMap().GetNearlyObjID(-1L, (int)e2.getX(), (int)e2.getY(), this.mMapController.nearlyRadius);
                if (s2 == null || s2.equals("")) break block8;
                if (null == this.mMapController.mListeners) break block9;
                GeoPoint gp = null;
                if (this.getProjection() != null) {
                    gp = this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                }
                for (ak listener : this.mMapController.mListeners) {
                    if (null == listener) continue;
                    if (listener.b(s2)) {
                        this.mMapController.mHasMapObjDraging = true;
                        continue;
                    }
                    if (gp == null) continue;
                    listener.c(gp);
                }
                break block9;
            }
            if (null != this.mMapController.mListeners) {
                GeoPoint gp = null;
                if (this.getProjection() != null) {
                    gp = this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                }
                if (gp == null) {
                    return;
                }
                for (ak listener : this.mMapController.mListeners) {
                    if (null == listener || gp == null) continue;
                    listener.c(gp);
                }
            }
        }
    }

    public boolean onFling(MotionEvent e12, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    @Override
    public MapController getController() {
        return this.mMapController;
    }

    public void animateTo(MapStatus st, int animTime) {
        if (this.mMapController != null) {
            this.mMapController.setMapStatusWithAnimation(st, animTime);
        }
    }

    @Override
    public int getLatitudeSpan() {
        MapStatus mapStatus = this.getMapStatus();
        k p2 = (k)this.getProjection();
        GeoPoint viewTopLeft = p2.fromPixels(mapStatus.winRound.left, mapStatus.winRound.top);
        GeoPoint viewBottomRight = p2.fromPixels(mapStatus.winRound.right - 1, mapStatus.winRound.bottom - 1);
        return (int)Math.abs(viewTopLeft.getLatitude() - viewBottomRight.getLatitude());
    }

    @Override
    public int getLongitudeSpan() {
        MapStatus mapStatus = this.getMapStatus();
        k p2 = (k)this.getProjection();
        GeoPoint viewTopLeft = p2.fromPixels(mapStatus.winRound.left, mapStatus.winRound.top);
        GeoPoint viewBottomRight = p2.fromPixels(mapStatus.winRound.right - 1, mapStatus.winRound.bottom - 1);
        return (int)Math.abs(viewBottomRight.getLongitude() - viewTopLeft.getLongitude());
    }

    @Override
    public void setMapCenter(GeoPoint geoPoint) {
        if (this.mMapController != null) {
            MapStatus mapStatus = this.mMapController.getMapStatus();
            mapStatus.centerPtX = geoPoint.getLongitude();
            mapStatus.centerPtY = geoPoint.getLatitude();
            this.mMapController.setMapStatus(mapStatus);
        }
    }

    @Override
    public GeoPoint getMapCenter() {
        if (this.mMapController == null) {
            return null;
        }
        MapStatus mapStatus = this.mMapController.getMapStatus();
        GeoPoint geoPoint = new GeoPoint(mapStatus.centerPtY, mapStatus.centerPtX);
        return geoPoint;
    }

    @Override
    public void setZoomLevel(float zoomLevel) {
        if (this.mMapController == null) {
            return;
        }
        float iLevel = zoomLevel;
        int maxZoomLevel = 22;
        IndoorMapInfo indoorMapInfo = this.getController().getFocusedBaseIndoorMapInfo();
        if (indoorMapInfo != null) {
            maxZoomLevel = 22;
        }
        if (iLevel < 4.0f) {
            iLevel = 4.0f;
        } else if (iLevel > (float)maxZoomLevel) {
            iLevel = 22.0f;
        }
        MapStatus st = this.getMapStatus();
        if (st != null) {
            st.level = iLevel;
            this.animateTo(st, 300);
        }
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.setZoomLevel((float)zoomLevel);
    }

    @Override
    public float getZoomLevel() {
        return this.mMapController != null ? this.mMapController.getZoomLevel() : 0.0f;
    }

    @Override
    public float getCurrentZoomLevel() {
        return this.mMapController != null ? this.mMapController.getCurrentZoomLevel() : 0.0f;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.mMapController != null) {
            MapStatus mapStatus = this.mMapController.getMapStatus();
            mapStatus.rotation = rotation;
            this.mMapController.setMapStatus(mapStatus);
        }
    }

    @Override
    public int getMapRotation() {
        if (this.mMapController == null) {
            return 0;
        }
        MapStatus mapStatus = this.mMapController.getMapStatus();
        return mapStatus.rotation;
    }

    @Override
    public void setOverlooking(int overlooking) {
        if (this.mMapController != null) {
            MapStatus mapStatus = this.mMapController.getMapStatus();
            mapStatus.overlooking = overlooking;
            this.mMapController.setMapStatus(mapStatus);
        }
    }

    @Override
    public double getOverlooking() {
        if (this.mMapController == null) {
            return 0.0;
        }
        MapStatus mapStatus = this.mMapController.getMapStatus();
        return mapStatus.overlooking;
    }

    @Override
    public void setWinRound(MapStatus.WinRound winRound) {
        if (this.mMapController != null) {
            MapStatus mapStatus = this.mMapController.getMapStatus();
            mapStatus.winRound = winRound;
            this.mMapController.setMapStatus(mapStatus);
        }
    }

    @Override
    public MapStatus.WinRound getWinRound() {
        if (this.mMapController == null) {
            return null;
        }
        MapStatus mapStatus = this.mMapController.getMapStatus();
        return mapStatus.winRound;
    }

    @Override
    public void setGeoRound(MapStatus.GeoBound geoRound) {
    }

    @Override
    public MapStatus.GeoBound getGeoRound() {
        if (this.mMapController == null) {
            return null;
        }
        MapStatus mapStatus = this.mMapController.getMapStatus();
        return mapStatus.geoRound;
    }

    @Override
    public void setMapStatus(MapStatus mapStatus) {
        if (this.mMapController != null) {
            this.mMapController.setMapStatus(mapStatus);
        }
    }

    @Override
    public MapStatus getMapStatus() {
        return this.mMapController != null ? this.mMapController.getMapStatus() : null;
    }

    @Override
    public MapStatus getCurrentMapStatus() {
        return this.mMapController != null ? this.mMapController.getCurrentMapStatus() : null;
    }

    @Override
    public boolean addBmLayer(BmLayer bmLayer) {
        return this.a(0L, bmLayer);
    }

    @Override
    public boolean addBmLayerBelow(Overlay overlay, BmLayer bmLayer) {
        if (overlay != null) {
            return this.a(overlay.mLayerID, bmLayer);
        }
        return this.a(0L, bmLayer);
    }

    public boolean addBmLayerBelow(long overlayId, BmLayer bmLayer) {
        return this.a(overlayId, bmLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean a(long overlayId, BmLayer bmLayer) {
        if (bmLayer == null || this.mMapController == null) {
            return false;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        MapTextureView mapTextureView = this;
        synchronized (mapTextureView) {
            if (this.c.contains(bmLayer)) {
                return false;
            }
            this.c.add(bmLayer);
        }
        return baseMap.addBmLayerBelow(overlayId, bmLayer.getNativeInstance(), 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeBmLayer(BmLayer bmLayer) {
        if (bmLayer == null || this.mMapController == null) {
            return false;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        baseMap.removeBmLayer(bmLayer.getNativeInstance());
        MapTextureView mapTextureView = this;
        synchronized (mapTextureView) {
            this.c.remove(bmLayer);
        }
        return true;
    }

    @Override
    public List<BmLayer> getBmlayers() {
        return this.c;
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.innerOverlayList;
    }

    public Overlay getPopupOverlay() {
        return null;
    }

    public synchronized Overlay getOverlay(int layerType) {
        for (Overlay layer : this.innerOverlayList) {
            if (layer.mType != layerType) continue;
            return layer;
        }
        return null;
    }

    public synchronized Overlay getOverlay(Class<?> overlayClass) {
        for (Overlay layer : this.innerOverlayList) {
            if (layer.getClass() != overlayClass) continue;
            return layer;
        }
        return null;
    }

    @Override
    public Projection getProjection() {
        return this.mProjection;
    }

    @Override
    public boolean enable3D() {
        return false;
    }

    @Override
    public boolean isSatellite() {
        return false;
    }

    @Override
    public boolean isTraffic() {
        return false;
    }

    @Override
    public boolean isStreetRoad() {
        return false;
    }

    @Override
    public boolean isBaseIndoorMap() {
        return false;
    }

    @Override
    public void setBaseIndoorMap(boolean on) {
    }

    @Override
    public void setSatellite(boolean on) {
    }

    @Override
    public void setStreetRoad(boolean on) {
    }

    @Override
    public void setTraffic(boolean on) {
        AppBaseMap baseMap;
        if (this.mMapController != null && (baseMap = this.mMapController.getBaseMap()) != null) {
            baseMap.ShowTrafficMap(on);
        }
    }

    @Override
    public void setMapTo2D(boolean on) {
    }

    protected void initInnerOverlays() {
        if (this.mMapController == null) {
            return;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return;
        }
        this.clearInnerOverlays();
    }

    protected void clearInnerOverlays() {
        if (this.mMapController == null) {
            return;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return;
        }
        if (this.overlayMapCallBack == null) {
            return;
        }
        this.innerOverlayList.clear();
        this.overlayMapCallBack.a();
    }

    @Override
    public boolean addOverlay(Overlay overlay) {
        if (overlay == null || this.mMapController == null) {
            return false;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        if (overlay instanceof InnerOverlay) {
            if (((InnerOverlay)overlay).mBaseMap == null) {
                ((InnerOverlay)overlay).mBaseMap = this.getController().getBaseMap();
            }
            if (((InnerOverlay)overlay).addedToMapView()) {
                this.innerOverlayList.add(overlay);
                this.overlayMapCallBack.a((InnerOverlay)overlay);
                return true;
            }
            return false;
        }
        if (overlay instanceof ItemizedOverlay) {
            overlay.mLayerID = baseMap.AddLayer(((ItemizedOverlay)overlay).getUpdateType(), 0, "item");
            if (overlay.mLayerID == 0L) {
                return false;
            }
            this.innerOverlayList.add(overlay);
            ((ItemizedOverlay)overlay).a();
            baseMap.SetLayersClickable(overlay.mLayerID, true);
            baseMap.ShowLayers(overlay.mLayerID, true);
            baseMap.UpdateLayers(overlay.mLayerID);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeOverlay(Overlay overlay) {
        if (overlay == null || this.mMapController == null) {
            return false;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        baseMap.ClearLayer(overlay.mLayerID);
        baseMap.ShowLayers(overlay.mLayerID, false);
        baseMap.UpdateLayers(overlay.mLayerID);
        baseMap.RemoveLayer(overlay.mLayerID);
        if (overlay instanceof ItemizedOverlay) {
            this.innerOverlayList.remove(overlay);
        } else if (overlay instanceof InnerOverlay) {
            this.innerOverlayList.remove(overlay);
            this.overlayMapCallBack.a(overlay);
        }
        overlay.mLayerID = 0L;
        return true;
    }

    @Override
    public boolean switchOverlay(Overlay overlaySrc, Overlay overlayDest) {
        if (overlaySrc == null || overlayDest == null || this.mMapController == null) {
            return false;
        }
        AppBaseMap baseMap = this.mMapController.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        return baseMap.SwitchLayer(overlaySrc.mLayerID, overlayDest.mLayerID);
    }

    @Override
    public void saveScreenToLocal(String strPath) {
    }

    @Override
    public float getZoomToBound(MapBound bound) {
        return this.getZoomToBound(bound, this.a, this.b);
    }

    @Override
    public float getZoomToBoundF(MapBound bound, int width, int height) {
        if (this.mMapController == null) {
            return 0.0f;
        }
        Bundle bd = new Bundle();
        bd.putInt("left", bound.leftBottomPt.getIntX());
        bd.putInt("bottom", bound.leftBottomPt.getIntY());
        bd.putInt("right", bound.rightTopPt.getIntX());
        bd.putInt("top", bound.rightTopPt.getIntY());
        return this.mMapController.getZoomToBoundF(bd);
    }

    @Override
    public float getZoomToBoundF(MapBound bound) {
        return this.getZoomToBoundF(bound, this.a, this.b);
    }

    @Override
    public float getZoomToBound(MapBound bound, int width, int height) {
        if (this.mMapController == null) {
            return 0.0f;
        }
        Bundle bd = new Bundle();
        bd.putInt("left", bound.leftBottomPt.getIntX());
        bd.putInt("bottom", bound.leftBottomPt.getIntY());
        bd.putInt("right", bound.rightTopPt.getIntX());
        bd.putInt("top", bound.rightTopPt.getIntY());
        return this.mMapController.getZoomToBound(bd, width, height);
    }

    @Override
    public void refresh(Overlay overlay) {
        if (overlay == null || this.mMapController == null) {
            return;
        }
        if (overlay instanceof ItemizedOverlay && ((ItemizedOverlay)overlay).b()) {
            if (((ItemizedOverlay)overlay).getAllItem().size() <= 0) {
                this.mMapController.getBaseMap().ClearLayer(overlay.mLayerID);
                this.mMapController.getBaseMap().ShowLayers(overlay.mLayerID, false);
                this.mMapController.getBaseMap().UpdateLayers(overlay.mLayerID);
            } else {
                this.mMapController.getBaseMap().ShowLayers(overlay.mLayerID, true);
                this.mMapController.getBaseMap().UpdateLayers(overlay.mLayerID);
            }
            ((ItemizedOverlay)overlay).a(false);
        }
        if (this.mMapController != null && this.mMapController.getBaseMap() != null) {
            this.mMapController.getBaseMap().UpdateLayers(overlay.mLayerID);
        }
    }

    @Override
    public void onResume() {
        if (this.mMapController != null) {
            this.mMapController.getBaseMap().OnResume();
        }
        super.onResume();
    }

    @Override
    public void onPause() {
        if (this.mMapController != null) {
            this.mMapController.getBaseMap().OnPause();
        }
        super.onPause();
    }

    public void onDestroy() {
        if (this.mBaseMapInner != null) {
            if (null != this.mBaseMapInner.h) {
                for (ak listener : this.mBaseMapInner.h) {
                    if (null == listener) continue;
                    listener.d();
                }
            }
            this.mBaseMapInner.O();
            this.mBaseMapInner = null;
        }
        this.mMapController.unInit();
        this.mMapController = null;
        this.overlayMapCallBack.a();
        this.overlayMapCallBack = null;
        this.mProjection = null;
    }

    public void destroyForMultiViews() {
        if (this.mMapController != null) {
            this.mMapController.unInitForMultiTextureView();
            this.mMapController = null;
        }
        if (this.overlayMapCallBack != null) {
            this.overlayMapCallBack.a();
            this.overlayMapCallBack = null;
        }
        this.mProjection = null;
    }

    public void onRecycle() {
        if (this.mMapController != null && this.mMapController.getBaseMap() != null) {
            this.mMapController.getBaseMap().ResetImageRes();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        MapStatus st = this.getMapStatus();
        if (st == null) {
            return false;
        }
        int count = event.getPointerCount();
        for (int i2 = 0; i2 < count; ++i2) {
            int x2 = (int)event.getX(i2);
            int y2 = (int)event.getY(i2);
            if (x2 >= st.winRound.left && x2 <= st.winRound.right && y2 >= st.winRound.top && y2 <= st.winRound.bottom) continue;
            return false;
        }
        try {
            if (this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(event)) {
                return true;
            }
            if (this.mMapController != null && this.mMapController.handleTouchEvent(event)) {
                return true;
            }
        }
        catch (Exception e2) {
            return super.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    public void onBackground() {
        this.onBackground(false);
    }

    public void onBackground(boolean force) {
        if (!force && this.d) {
            return;
        }
        if (this.mMapController != null && this.mMapController.getBaseMap() != null) {
            this.mMapController.getBaseMap().OnBackground();
        }
        this.d = true;
    }

    public void onForeground() {
        this.onForeground(false);
    }

    public void onForeground(boolean force) {
        if (force || this.d) {
            if (this.mMapController != null && this.mMapController.getBaseMap() != null) {
                this.mMapController.getBaseMap().OnForeground();
            }
            this.d = false;
        }
    }

    public void setSupBackgroundDraw(boolean enable) {
        MapController mapController = this.mMapController;
        if (mapController == null) {
            return;
        }
        mapController.setSupBackgroundDraw(enable);
    }

    public boolean isSetBackgroundDraw() {
        MapController mapController = this.mMapController;
        if (mapController == null) {
            return false;
        }
        return mapController.isSetBackgroundDraw();
    }

    private class b
    extends GestureDetector.SimpleOnGestureListener {
        private b() {
        }

        public void onLongPress(MotionEvent e2) {
            block9: {
                block8: {
                    super.onLongPress(e2);
                    if (MapTextureView.this.mMapController == null || MapTextureView.this.mMapController.getBaseMap() == null || !MapTextureView.this.mMapController.mIsMapLoadFinish) {
                        return;
                    }
                    String s2 = MapTextureView.this.mMapController.getBaseMap().GetNearlyObjID(-1L, (int)e2.getX(), (int)e2.getY(), MapTextureView.this.mMapController.nearlyRadius);
                    if (s2 == null || s2.equals("")) break block8;
                    if (null == MapTextureView.this.mMapController.mListeners) break block9;
                    GeoPoint gp = null;
                    if (MapTextureView.this.getProjection() != null) {
                        gp = MapTextureView.this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                    }
                    for (ak listener : MapTextureView.this.mMapController.mListeners) {
                        if (null == listener) continue;
                        if (listener.b(s2)) {
                            MapTextureView.this.mMapController.mHasMapObjDraging = true;
                            continue;
                        }
                        if (gp == null) continue;
                        listener.c(gp);
                    }
                    break block9;
                }
                if (null != MapTextureView.this.mMapController.mListeners) {
                    GeoPoint gp = null;
                    if (MapTextureView.this.getProjection() != null) {
                        gp = MapTextureView.this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                    }
                    if (gp == null) {
                        return;
                    }
                    for (ak listener : MapTextureView.this.mMapController.mListeners) {
                        if (null == listener || gp == null) continue;
                        listener.c(gp);
                    }
                }
            }
        }

        /* synthetic */ b(x x1) {
            this();
        }
    }

    private class a
    implements GLSurfaceView.EGLContextFactory {
        private int b = 12440;

        private a() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.b, 2, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, attrib_list);
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                this.a("eglDestroyContex", egl.eglGetError());
            }
            MapTextureView.this.onRecycle();
        }

        public void a(String function, int error) {
            String message = this.b(function, error);
            throw new RuntimeException(message);
        }

        public String b(String function, int error) {
            return function + " failed: " + this.a(error);
        }

        private String a(int error) {
            switch (error) {
                case 12288: {
                    return "EGL_SUCCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
            }
            return this.b(error);
        }

        private String b(int value) {
            return "0x" + Integer.toHexString(value);
        }

        /* synthetic */ a(x x1) {
            this();
        }
    }

    public static interface c {
        public void a(int var1);
    }
}

