/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import com.baidu.platform.comapi.map.InnerOverlay;
import com.baidu.platform.comapi.map.OverlayLocationData;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LocationOverlay
extends InnerOverlay {
    private AppBaseMap a;

    public LocationOverlay() {
        super(7);
    }

    public LocationOverlay(AppBaseMap baseMap) {
        super(7, baseMap);
        this.a = baseMap;
    }

    @Override
    public String getLayerTag() {
        return "location";
    }

    @Override
    public boolean getDefaultShowStatus() {
        return true;
    }

    public void setLocationLayerData(List<OverlayLocationData> list) {
        if (list == null || list.size() <= 0 || this.mLayerID == 0L) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("locationaddr", this.mLayerID);
        ArrayList<ParcelItem> parcle = new ArrayList<ParcelItem>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            byte[] bmpData;
            ByteBuffer dstBuffer;
            Bundle subBunle;
            Bitmap bmp;
            ParcelItem subParacel;
            OverlayLocationData subItem = list.get(i2);
            if (subItem.getImgType() == "arrowicon") {
                if (subItem.getImage() == null) continue;
                subParacel = new ParcelItem();
                bmp = subItem.getImage();
                subBunle = new Bundle();
                dstBuffer = ByteBuffer.allocate(bmp.getWidth() * bmp.getHeight() * 4);
                bmp.copyPixelsToBuffer((Buffer)dstBuffer);
                bmpData = dstBuffer.array();
                subBunle.putByteArray("imgbin", bmpData);
                subBunle.putInt("w", subItem.getImgWidth());
                subBunle.putInt("h", subItem.getImgHeight());
                subBunle.putInt("len", bmp.getWidth() * bmp.getHeight() * 4);
                subBunle.putInt("rotation", 1);
                subBunle.putString("imgtype", subItem.getImgType());
                subBunle.putString("name", subItem.getImgName());
                subBunle.putFloat("arrowsize", subItem.getArrowSize());
                subParacel.setBundle(subBunle);
                parcle.add(subParacel);
                continue;
            }
            if (subItem.getImgType() == "icon") {
                if (subItem.getImage() == null) continue;
                subParacel = new ParcelItem();
                bmp = subItem.getImage();
                subBunle = new Bundle();
                dstBuffer = ByteBuffer.allocate(bmp.getWidth() * bmp.getHeight() * 4);
                bmp.copyPixelsToBuffer((Buffer)dstBuffer);
                bmpData = dstBuffer.array();
                subBunle.putByteArray("imgbin", bmpData);
                subBunle.putInt("w", subItem.getImgWidth());
                subBunle.putInt("h", subItem.getImgHeight());
                subBunle.putInt("len", bmp.getWidth() * bmp.getHeight() * 4);
                subBunle.putInt("rotation", subItem.isRotation());
                subBunle.putInt("animation", subItem.isAnimation());
                subBunle.putString("imgtype", subItem.getImgType());
                subBunle.putString("name", subItem.getImgName());
                subBunle.putFloat("markersize", subItem.getMarkerSize());
                subParacel.setBundle(subBunle);
                parcle.add(subParacel);
                continue;
            }
            if (subItem.getImgType() == "gificon") {
                if (subItem.getGIFImgPath() == null) continue;
                subParacel = new ParcelItem();
                Bundle subBunle2 = new Bundle();
                subBunle2.putInt("rotation", subItem.isRotation());
                subBunle2.putInt("animation", subItem.isAnimation());
                subBunle2.putString("gifpath", subItem.getGIFImgPath());
                subBunle2.putString("imgtype", subItem.getImgType());
                subBunle2.putString("name", subItem.getImgName());
                subBunle2.putFloat("markersize", subItem.getMarkerSize());
                subParacel.setBundle(subBunle2);
                parcle.add(subParacel);
                continue;
            }
            if (subItem.getImage() == null) {
                return;
            }
            subParacel = new ParcelItem();
            bmp = subItem.getImage();
            subBunle = new Bundle();
            dstBuffer = ByteBuffer.allocate(bmp.getWidth() * bmp.getHeight() * 4);
            bmp.copyPixelsToBuffer((Buffer)dstBuffer);
            bmpData = dstBuffer.array();
            subBunle.putByteArray("imgbin", bmpData);
            subBunle.putInt("w", subItem.getImgWidth());
            subBunle.putInt("h", subItem.getImgHeight());
            subBunle.putInt("rotation", subItem.isRotation());
            subBunle.putString("name", subItem.getImgName() + "_" + Arrays.hashCode(bmpData));
            subParacel.setBundle(subBunle);
            parcle.add(subParacel);
        }
        if (parcle.size() > 0) {
            Parcelable[] midpar = new ParcelItem[parcle.size()];
            for (int j2 = 0; j2 < parcle.size(); ++j2) {
                midpar[j2] = (ParcelItem)parcle.get(j2);
            }
            bundle.putParcelableArray("imagedata", midpar);
        }
        this.a.SetLocationLayerData(bundle);
    }

    public void clearLocationLayerData(Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putLong("locationaddr", this.mLayerID);
        this.a.ClearLocationLayerData(bundle);
    }

    public void beginLocationLayerAnimation() {
        this.a.BeginLocationLayerAnimation();
    }
}

