/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.location;

import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.basestruct.a;
import com.baidu.platform.comapi.location.CoordinateUtil;
import java.util.ArrayList;

public class CoordinateUtilEx {
    public static Point getGeoPointFromString(String strGeo) {
        if (strGeo == null || strGeo.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToPoint(strGeo);
    }

    public static String getStringFromGeoPoint(Point point) {
        return CoordinateUtil.pointToGeoString(point);
    }

    @Deprecated
    public static a getGeoComplexPtBoundFromString(String strGeo) {
        if (strGeo == null || strGeo.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToComplexPtBound(strGeo);
    }

    @Deprecated
    public static a getGeoComplexPointFromString(String strGeo) {
        if (strGeo == null || strGeo.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToComplexPt(strGeo);
    }

    public static double getDistanceByMc(Point pt1, Point pt2) {
        return CoordinateUtil.getDistanceByMc(pt1.getDoubleX(), pt1.getDoubleY(), pt2.getDoubleX(), pt2.getDoubleY());
    }

    public static double getDistanceByMc(GeoPoint pt1, GeoPoint pt2) {
        return CoordinateUtil.getDistanceByMc(pt1.getLongitude(), pt1.getLatitude(), pt2.getLongitude(), pt2.getLatitude());
    }

    public static Point getIntermediatePointByMC(Point pt1, Point pt2, double fraction) {
        return CoordinateUtil.getIntermediatePointByMC(pt1.getDoubleX(), pt1.getDoubleY(), pt2.getDoubleX(), pt2.getDoubleY(), fraction);
    }

    public static Point getIntermediatePointByMC(GeoPoint pt1, GeoPoint pt2, double fraction) {
        return CoordinateUtil.getIntermediatePointByMC(pt1.getLongitude(), pt1.getLatitude(), pt2.getLongitude(), pt2.getLatitude(), fraction);
    }

    public static Point Coordinate_encryptEx(float x2, float y2, String bType) {
        if (bType == null) {
            return null;
        }
        if (bType.equals("")) {
            bType = "bd09ll";
        }
        switch (bType) {
            case "wgs84": {
                return CoordinateUtil.wgs84Tobd09mc(x2, y2);
            }
            case "gcj02": {
                return CoordinateUtil.gcj02Tobd09mc(x2, y2);
            }
            case "bd09ll": {
                return CoordinateUtil.bd09llTobd09mc(x2, y2);
            }
            case "bd09mc": {
                return new Point(x2, y2);
            }
        }
        return null;
    }

    public static ArrayList<Point> Coordinate_encryptExArray(ArrayList<Point> pointArrayList, String bType) {
        if (bType == null) {
            return null;
        }
        if (bType.equals("")) {
            bType = "bd09ll";
        }
        if (!(bType.equals("bd09ll") || bType.equals("bd09mc") || bType.equals("gcj02") || bType.equals("wgs84"))) {
            return null;
        }
        float[] x2 = new float[pointArrayList.size()];
        float[] y2 = new float[pointArrayList.size()];
        for (int i2 = 0; i2 < pointArrayList.size(); ++i2) {
            x2[i2] = (float)pointArrayList.get(i2).getIntX() / 100000.0f;
            y2[i2] = (float)pointArrayList.get(i2).getIntY() / 100000.0f;
        }
        ArrayList<Point> mcList = new ArrayList<Point>();
        for (int i3 = 0; i3 < x2.length; ++i3) {
            Point p2 = null;
            switch (bType) {
                case "wgs84": {
                    p2 = CoordinateUtil.wgs84Tobd09mc(x2[i3], y2[i3]);
                    break;
                }
                case "gcj02": {
                    p2 = CoordinateUtil.gcj02Tobd09mc(x2[i3], y2[i3]);
                    break;
                }
                case "bd09ll": {
                    p2 = CoordinateUtil.bd09llTobd09mc(x2[i3], y2[i3]);
                    break;
                }
                case "bd09mc": {
                    p2 = new Point(x2[i3], y2[i3]);
                    break;
                }
            }
            if (p2 == null) continue;
            mcList.add(p2);
        }
        return mcList;
    }
}

