/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.bmsdk.animation;

import com.baidu.platform.comapi.bmsdk.BmDrawItem;
import com.baidu.platform.comapi.bmsdk.BmGeoElement;
import com.baidu.platform.comapi.bmsdk.animation.BmAnimation;
import com.baidu.platform.comapi.bmsdk.b;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BmTrackAnimation
extends BmAnimation {
    public static final int TRACK_NONE = 0;
    public static final int TRACK_X = 1;
    public static final int TRACK_Y = 2;
    public static final int TRACK_XY = 3;
    public static final int TRACK_FORWARD = 32;
    public static final int TRACK_BACKWARD = 64;
    public static final int TRACK_MOVE_FORWARD = 128;
    public static final int TRACK_MOVE_BACKWARD = 256;
    private a mTrackListener = null;
    private b mFromPt;
    private b mToPt;
    private float mFromRadio;
    private float mToRadio;
    private static Object sync = new Object();
    private static List<WeakReference<BmTrackAnimation>> wkListenerAnimations = new ArrayList<WeakReference<BmTrackAnimation>>();

    public BmTrackAnimation() {
        super(85, BmTrackAnimation.nativeCreate());
    }

    public boolean setTrackPosRadio(float fromRadio, float toRadio) {
        this.mFromRadio = fromRadio;
        this.mToRadio = toRadio;
        this.mFromPt = null;
        this.mToPt = null;
        return BmTrackAnimation.nativeSetTrackPosRadio(this.nativeInstance, fromRadio, toRadio);
    }

    public boolean setTrackPosRadio(float toRadio) {
        this.mToRadio = toRadio;
        this.mFromPt = null;
        this.mToPt = null;
        return BmTrackAnimation.nativeSetTrackEndRadio(this.nativeInstance, toRadio);
    }

    public boolean setTrackPos(b from, b to) {
        this.mFromPt = from;
        this.mToPt = to;
        this.mFromRadio = -1.0f;
        this.mToRadio = -1.0f;
        return BmTrackAnimation.nativeSetTrackPos(this.nativeInstance, from.a, from.b, to.a, to.b);
    }

    public boolean setTrackPos(b to) {
        this.mToPt = to;
        this.mFromRadio = -1.0f;
        this.mToRadio = -1.0f;
        return BmTrackAnimation.nativeSetTrackEndPos(this.nativeInstance, to.a, to.b);
    }

    public boolean setSdkTrack(BmDrawItem track) {
        int objType;
        if (track != null && (objType = track.getObjType()) != 25) {
            return false;
        }
        return BmTrackAnimation.nativeSetSdkTrack(this.nativeInstance, track == null ? 0L : track.getNativeInstance());
    }

    public boolean setTrackLine(BmDrawItem trackLine) {
        int objType;
        if (trackLine != null && (objType = trackLine.getObjType()) != 8 && objType != 9 && objType != 10) {
            return false;
        }
        return BmTrackAnimation.nativeSetTrackLine(this.nativeInstance, trackLine == null ? 0L : trackLine.getNativeInstance());
    }

    public boolean setTrackPath(BmGeoElement geoPath) {
        return BmTrackAnimation.nativeSetTrackPath(this.nativeInstance, geoPath == null ? 0L : geoPath.getNativeInstance());
    }

    public boolean setTrackUpdateListener(a listener) {
        this.mTrackListener = listener;
        if (listener != null) {
            BmTrackAnimation.addAnimation(this);
        } else {
            BmTrackAnimation.removeAnimation(this);
        }
        return BmTrackAnimation.nativeSetTrackUpdateListener(this.nativeInstance, listener != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dispatchTrackUpdateListener(long animShell, double mcLnt, double mcLat, float fAngle, float fraction) {
        Object object = sync;
        synchronized (object) {
            for (int i2 = wkListenerAnimations.size() - 1; i2 >= 0; --i2) {
                BmTrackAnimation anim = (BmTrackAnimation)wkListenerAnimations.get(i2).get();
                if (anim == null) {
                    wkListenerAnimations.remove(i2);
                    continue;
                }
                if (anim.getNativeInstance() != animShell || anim.mTrackListener == null) continue;
                anim.mTrackListener.a(new b(mcLnt, mcLat), fAngle, fraction);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAnimation(BmTrackAnimation animation) {
        Object object = sync;
        synchronized (object) {
            boolean bFind = false;
            for (int i2 = wkListenerAnimations.size() - 1; i2 >= 0; --i2) {
                BmTrackAnimation anim = (BmTrackAnimation)wkListenerAnimations.get(i2).get();
                if (anim == null) {
                    wkListenerAnimations.remove(i2);
                    continue;
                }
                if (anim != animation) continue;
                bFind = true;
            }
            if (!bFind) {
                wkListenerAnimations.add(new WeakReference<BmTrackAnimation>(animation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAnimation(BmTrackAnimation animation) {
        Object object = sync;
        synchronized (object) {
            for (int i2 = wkListenerAnimations.size() - 1; i2 >= 0; --i2) {
                BmTrackAnimation anim = (BmTrackAnimation)wkListenerAnimations.get(i2).get();
                if (anim == null) {
                    wkListenerAnimations.remove(i2);
                    continue;
                }
                if (anim != animation) continue;
                wkListenerAnimations.remove(i2);
            }
        }
    }

    private static native long nativeCreate();

    private static native boolean nativeSetTrackPosRadio(long var0, float var2, float var3);

    private static native boolean nativeSetTrackEndRadio(long var0, float var2);

    private static native boolean nativeSetTrackPos(long var0, double var2, double var4, double var6, double var8);

    private static native boolean nativeSetTrackEndPos(long var0, double var2, double var4);

    private static native boolean nativeSetTrackLine(long var0, long var2);

    private static native boolean nativeSetSdkTrack(long var0, long var2);

    private static native boolean nativeSetTrackPath(long var0, long var2);

    private static native boolean nativeSetTrackUpdateListener(long var0, boolean var2);

    public static interface a {
        public void a(b var1, float var2, float var3);
    }
}

