/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.bmsdk.animation;

import com.baidu.platform.comapi.bmsdk.BmObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BmAnimation
extends BmObject {
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    private static final int START_ON_FIRST_FRAME = -1;
    private static final int ABSOLUTE = 0;
    private static final int RELATIVE_TO_SELF = 1;
    public static final int FILL_BEFORE = 0;
    public static final int FILL_FIRST = 1;
    public static final int FILL_AFTER = 2;
    int mFillMode = 0;
    long mStartDelay;
    long mRepeatDelay;
    long mDuration;
    int mRepeatCount = 0;
    int mRepeatMode = 1;
    private com.baidu.platform.comapi.bmsdk.animation.a mInterpolator;
    private a mListener;
    private String mExtParam = "";
    private static final int START = 1;
    private static final int END = 2;
    private static final int REPEAT = 3;
    private static Object sync = new Object();
    private static List<WeakReference<BmAnimation>> wkListenerAnimations = new ArrayList<WeakReference<BmAnimation>>();

    private BmAnimation() {
        super(80, 0L);
    }

    public BmAnimation(int objType, long naInstance) {
        super(objType, naInstance);
    }

    public boolean reset() {
        return BmAnimation.nativeReset(this.nativeInstance);
    }

    public boolean pause() {
        return BmAnimation.nativePause(this.nativeInstance);
    }

    public boolean resume() {
        return BmAnimation.nativeResume(this.nativeInstance);
    }

    public boolean cancel() {
        return BmAnimation.nativeCancel(this.nativeInstance);
    }

    public boolean setInterpolator(com.baidu.platform.comapi.bmsdk.animation.a i2) {
        this.mInterpolator = i2;
        return BmAnimation.nativeSetInterpolator(this.nativeInstance, i2 == null ? 0L : this.mInterpolator.getNativeInstance());
    }

    public boolean setStartDelay(long delayMillis) {
        this.mStartDelay = delayMillis;
        return BmAnimation.nativeSetStartDelay(this.nativeInstance, delayMillis);
    }

    public boolean setRepeatDelay(long delayMillis) {
        this.mRepeatDelay = delayMillis;
        return BmAnimation.nativeSetRepeatDelay(this.nativeInstance, delayMillis);
    }

    public boolean setDuration(long durationMillis) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = durationMillis;
        return BmAnimation.nativeSetDuration(this.nativeInstance, durationMillis);
    }

    public boolean setStartTime(long startTimeMillis) {
        return BmAnimation.nativeSetStartTime(this.nativeInstance, startTimeMillis);
    }

    public boolean start() {
        return this.setStartTime(-1L);
    }

    public boolean setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
        return BmAnimation.nativeSetRepeatMode(this.nativeInstance, repeatMode);
    }

    public boolean setRepeatCount(int repeatCount) {
        if (repeatCount < 0) {
            repeatCount = -1;
        }
        this.mRepeatCount = repeatCount;
        return BmAnimation.nativeSetRepeatCount(this.nativeInstance, this.mRepeatCount);
    }

    public boolean setFillMode(int fillMode) {
        this.mFillMode = fillMode;
        return BmAnimation.nativeSetFillMode(this.nativeInstance, fillMode);
    }

    public boolean setAnimationListener(a listener) {
        this.mListener = listener;
        if (listener != null) {
            BmAnimation.addAnimation(this);
        } else {
            BmAnimation.removeAnimation(this);
        }
        return BmAnimation.nativeSetListener(this.nativeInstance, listener != null);
    }

    public void setExtParam(String extParam) {
        this.mExtParam = extParam;
    }

    public String getExtParam() {
        return this.mExtParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dispatchAnimationListener(long animShell, int action) {
        Object object = sync;
        synchronized (object) {
            for (int i2 = wkListenerAnimations.size() - 1; i2 >= 0; --i2) {
                BmAnimation anim = (BmAnimation)wkListenerAnimations.get(i2).get();
                if (anim == null) {
                    wkListenerAnimations.remove(i2);
                    continue;
                }
                if (anim.nativeInstance != animShell || anim.mListener == null) continue;
                if (action == 1) {
                    anim.mListener.a(anim);
                    continue;
                }
                if (action == 2) {
                    anim.mListener.b(anim);
                    continue;
                }
                if (action != 3) continue;
                anim.mListener.c(anim);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAnimation(BmAnimation animation) {
        if (animation == null) {
            return;
        }
        Object object = sync;
        synchronized (object) {
            boolean bFind = false;
            for (int i2 = wkListenerAnimations.size() - 1; i2 >= 0; --i2) {
                BmAnimation anim = (BmAnimation)wkListenerAnimations.get(i2).get();
                if (anim == null || anim != animation) continue;
                bFind = true;
                break;
            }
            if (!bFind) {
                wkListenerAnimations.add(new WeakReference<BmAnimation>(animation));
            }
        }
    }

    private static void removeAnimation(BmAnimation animation) {
    }

    private static native boolean nativeSetInterpolator(long var0, long var2);

    private static native boolean nativeSetStartTime(long var0, long var2);

    private static native boolean nativePause(long var0);

    private static native boolean nativeResume(long var0);

    private static native boolean nativeSetDuration(long var0, long var2);

    private static native boolean nativeSetStartDelay(long var0, long var2);

    private static native boolean nativeSetRepeatDelay(long var0, long var2);

    private static native boolean nativeSetRepeatCount(long var0, int var2);

    private static native boolean nativeSetRepeatMode(long var0, int var2);

    private static native boolean nativeSetFillMode(long var0, int var2);

    private static native boolean nativeReset(long var0);

    private static native boolean nativeCancel(long var0);

    private static native boolean nativeSetListener(long var0, boolean var2);

    public static interface a {
        public void a(BmAnimation var1);

        public void b(BmAnimation var1);

        public void c(BmAnimation var1);
    }
}

