/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapsdkplatform.comapi.map;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapsdkplatform.comapi.util.AlgorithmUtil;
import com.baidu.mapsdkplatform.comapi.util.SyncSysInfo;
import com.baidu.mapsdkplatform.comjni.tools.JNITools;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class y {
    private String d(String geom) {
        String token = SyncSysInfo.getAuthToken();
        if (TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        String aesSaltKey = JNITools.getAESSaltKey(token);
        String aesVitKey = JNITools.getAESViKey(token);
        if (!(TextUtils.isEmpty((CharSequence)aesSaltKey) || TextUtils.isEmpty((CharSequence)aesVitKey) || TextUtils.isEmpty((CharSequence)geom))) {
            byte[] bytes = this.e(geom);
            try {
                byte[] decryptInfo = AlgorithmUtil.getDecryptInfo(aesVitKey, aesSaltKey, bytes);
                return new String(decryptInfo).trim();
            }
            catch (Exception e2) {
                Log.e((String)"PrismBuildingInfo", (String)"getBuildingGeom Decrypt failed");
            }
        }
        return null;
    }

    private byte[] e(String data) {
        int length = data.length() / 2;
        byte[] result = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            int first = Integer.parseInt(data.substring(i2 * 2, i2 * 2 + 1), 16);
            int second = Integer.parseInt(data.substring(i2 * 2 + 1, i2 * 2 + 2), 16);
            result[i2] = (byte)(first * 16 + second);
        }
        return result;
    }

    public ArrayList<LatLng> a(String geom) {
        String buildingGeom = this.d(geom);
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        if (!TextUtils.isEmpty((CharSequence)buildingGeom)) {
            String[] split = buildingGeom.split(";");
            for (int i2 = 0; i2 < split.length; ++i2) {
                String strLatLng = split[i2];
                String[] splitStr = strLatLng.split(",");
                if (splitStr.length != 2) continue;
                String strLongitude = splitStr[0];
                String strLatitude = splitStr[1];
                try {
                    double longitude = Double.parseDouble(strLongitude);
                    double latitude = Double.parseDouble(strLatitude);
                    LatLng latLng = new LatLng(latitude, longitude);
                    latLngs.add(latLng);
                    continue;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return latLngs;
    }

    public ArrayList<LatLng> b(String geom) {
        String buildingGeom = this.d(geom);
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        if (!TextUtils.isEmpty((CharSequence)buildingGeom)) {
            String[] split = buildingGeom.split("\\|");
            for (int i2 = 0; i2 < split.length; ++i2) {
                String strLatLng = split[i2];
                String[] splitStr = strLatLng.split(",");
                if (splitStr.length != 2) continue;
                String strLongitude = splitStr[0];
                String strLatitude = splitStr[1];
                try {
                    double longitude = Double.parseDouble(strLongitude);
                    double latitude = Double.parseDouble(strLatitude);
                    LatLng latLng = CoordUtil.mc2llDirect(new GeoPoint(latitude, longitude));
                    latLngs.add(latLng);
                    continue;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return latLngs;
    }

    public ArrayList<LatLng> c(String geom) {
        ArrayList<LatLng> deGenerateLatlngs;
        byte[] decodeHex = this.g(geom);
        byte[] bytes = JNITools.decryptPNKD(decodeHex);
        String latlngStr = null;
        if (Build.VERSION.SDK_INT >= 19) {
            latlngStr = new String(bytes, StandardCharsets.UTF_8);
        }
        if (null == (deGenerateLatlngs = this.f(latlngStr))) {
            return null;
        }
        ArrayList<LatLng> onDiffLatLngs = this.a(deGenerateLatlngs);
        return onDiffLatLngs;
    }

    private ArrayList<LatLng> f(String latLngStr) {
        if (TextUtils.isEmpty((CharSequence)latLngStr)) {
            return null;
        }
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        for (String generatelatlngStr : latLngStr.split("\\|")) {
            int lngInt;
            int latInt;
            String[] generatelatlng = generatelatlngStr.split(",");
            String latStr = generatelatlng[0];
            String lngStr = generatelatlng[1];
            try {
                latInt = Integer.parseInt(latStr);
                lngInt = Integer.parseInt(lngStr);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
                return null;
            }
            double lat = (float)latInt / 1000000.0f;
            double lng = (float)lngInt / 1000000.0f;
            LatLng latLng = new LatLng(lat, lng);
            latLngs.add(latLng);
        }
        return latLngs;
    }

    private ArrayList<LatLng> a(List<LatLng> latLngs) {
        ArrayList<LatLng> onDiffLatLngs = new ArrayList<LatLng>();
        onDiffLatLngs.add(0, latLngs.get(0));
        int count = latLngs.size();
        for (int i2 = 1; i2 < count; ++i2) {
            double onDiffLatitude = onDiffLatLngs.get((int)(i2 - 1)).latitude + latLngs.get((int)i2).latitude;
            double onDiffLongitude = onDiffLatLngs.get((int)(i2 - 1)).longitude + latLngs.get((int)i2).longitude;
            LatLng tmp = new LatLng(onDiffLatitude, onDiffLongitude);
            onDiffLatLngs.add(tmp);
        }
        return onDiffLatLngs;
    }

    private byte[] g(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        int l2 = inputString.length() / 2;
        byte[] result = new byte[l2];
        String tmp = null;
        for (int i2 = 0; i2 < l2; ++i2) {
            tmp = inputString.substring(2 * i2, 2 * i2 + 2);
            result[i2] = (byte)(Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }
}

