/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapauto.auth.util;

import android.text.TextUtils;
import com.baidu.mapauto.auth.org.spongycastle.asn1.i;
import com.baidu.mapauto.auth.org.spongycastle.asn1.m0;
import com.baidu.mapauto.auth.org.spongycastle.asn1.pkcs.a;
import com.baidu.mapauto.auth.org.spongycastle.asn1.s;
import com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b;
import com.baidu.mapauto.auth.org.spongycastle.util.io.pem.c;
import com.baidu.mapauto.auth.util.Base64Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAUtil {
    private static final String ALGORITHM_KEY = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ALGORITHMS = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    private static final int KEY_SIZE = 2048;
    private static KeyPair keyPair;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyPair generateKeyPair() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_KEY);
        }
        catch (Exception exception) {
            return null;
        }
        keyPairGenerator.initialize(2048, new SecureRandom());
        if (keyPair != null) return keyPair;
        keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    /*
     * WARNING - void declaration
     */
    public static String encryptToHexStringPub(String plainData, PublicKey publicKey) {
        void var1_1;
        if (!TextUtils.isEmpty((CharSequence)plainData) && var1_1 != null) {
            String string;
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(ALGORITHMS);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            cipher.init(1, (Key)var1_1);
            return RSAUtil.byte2Hex(cipher.doFinal(string.getBytes(StandardCharsets.UTF_8)));
        }
        return null;
    }

    public static String convertCS2Pem(byte[] publicKeyPKCS) {
        StringWriter stringWriter;
        Object object;
        com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b b2;
        com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b b3 = b2;
        try {
            b2 = new com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b(com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b.c, (byte[])object);
        }
        catch (IOException iOException) {
            return null;
        }
        object = stringWriter;
        stringWriter = new StringWriter();
        c c2 = new c((StringWriter)object);
        c2.a(b3);
        ((Writer)c2).close();
        return stringWriter.toString();
    }

    public static String pemString2PemFormat(String key) {
        String string;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (i2 != 0 && i2 % 64 == 0) {
                stringBuffer2.append('\n');
            }
            stringBuffer2.append(string.charAt(i2));
        }
        return stringBuffer2.toString();
    }

    public static String pemFormat2PemString(String key) {
        String string;
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
        while (true) {
            string = bufferedReader2.readLine();
            if (string == null) break;
            if (string.contains("-----END RSA PUBLIC KEY-----")) continue;
            if (string.contains("-----BEGIN RSA PUBLIC KEY-----")) continue;
            stringBuilder2.append(string);
        }
        try {
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            return stringBuilder2.toString();
        }
    }

    public static PublicKey getPublicKeyFromPemString(String key, boolean hasLine) {
        Object object;
        if (!hasLine) {
            object = RSAUtil.pemString2PemFormat((String)object);
        }
        object = RSAUtil.formatPublicKeyPKCS1ToPKCS8(Base64Util.decode(((String)object).getBytes(StandardCharsets.UTF_8)));
        try {
            return KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(new X509EncodedKeySpec((byte[])object));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    public static PrivateKey getPrivateKeyFromPemString(String key, boolean hasLine) {
        Object object;
        if (!hasLine) {
            object = RSAUtil.pemString2PemFormat((String)object);
        }
        object = Base64Util.decode(((String)object).getBytes(StandardCharsets.UTF_8));
        try {
            return (PrivateKey)((Object)KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(new PKCS8EncodedKeySpec((byte[])object)));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPublicKeyCS1Pem(PublicKey pub) {
        Object object;
        block15: {
            block14: {
                byte[] byArray;
                try {
                    byArray = pub.getEncoded();
                }
                catch (IOException iOException) {
                    return null;
                }
                object = byArray;
                if (!(byArray instanceof b)) break block14;
                object = (b)object;
                break block15;
            }
            if (object != null) {
                b b2;
                b b3 = b2;
                b2 = new b(s.a(object));
                object = b3;
            } else {
                object = null;
            }
        }
        Object object2 = object;
        Object object3 = object2;
        object2.getClass();
        m0 m02 = ((b)object3).b;
        if (m02.b != 0) throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        Object object4 = object;
        ((i)object4)(com.baidu.mapauto.auth.org.spongycastle.util.a.a(m02.a));
        byte[] byArray = ((i)object4).a().d();
        byte[] byArray2 = byArray;
        RSAUtil.formatPublicKeyPKCS1ToPKCS8(byArray);
        return RSAUtil.pemFormat2PemString(RSAUtil.convertCS2Pem(byArray2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptHexStringBySec(String cipherData, PrivateKey privateKey) {
        void var1_1;
        Object object;
        if (TextUtils.isEmpty((CharSequence)cipherData)) {
            return null;
        }
        try {
            object = RSAUtil.hex2Byte((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Cipher cipher = Cipher.getInstance(ALGORITHMS);
        cipher.init(2, (Key)var1_1);
        return cipher.doFinal((byte[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static String encrypt(String data, PublicKey publicKey) throws Exception {
        void var1_1;
        MGF1ParameterSpec mGF1ParameterSpec;
        OAEPParameterSpec oAEPParameterSpec;
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
        OAEPParameterSpec oAEPParameterSpec2 = oAEPParameterSpec;
        MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
        mGF1ParameterSpec = new MGF1ParameterSpec("SHA-1");
        PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
        oAEPParameterSpec = new OAEPParameterSpec("SHA1", "MGF1", mGF1ParameterSpec2, pSpecified);
        cipher.init(1, (Key)var1_1, oAEPParameterSpec2);
        return RSAUtil.byte2Hex(cipher.doFinal(((String)((Object)oAEPParameterSpec2)).getBytes("UTF-8")));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(String sourceBase64RSA, PrivateKey privateKey) {
        void var1_1;
        OAEPParameterSpec oAEPParameterSpec;
        OAEPParameterSpec oAEPParameterSpec2;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
        }
        catch (Exception exception) {
            return null;
        }
        Cipher cipher2 = cipher;
        String string = oAEPParameterSpec2;
        oAEPParameterSpec2 = oAEPParameterSpec;
        oAEPParameterSpec = new OAEPParameterSpec("SHA1", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
        cipher2.init(2, (Key)var1_1, oAEPParameterSpec2);
        return cipher.doFinal(RSAUtil.hex2Byte(string));
    }

    public static byte[] hex2Byte(String string) {
        String string2;
        if (string != null && string2.length() >= 1) {
            byte[] byArray = new byte[string2.length() / 2];
            for (int i2 = 0; i2 < string2.length() / 2; ++i2) {
                int n2 = i2 * 2;
                int n3 = n2;
                int n4 = n2 + 1;
                n3 = Integer.parseInt(string2.substring(n4, n3 + 2), 16);
                byArray[i2] = (byte)(Integer.parseInt(string2.substring(n2, n4), 16) * 16 + n3);
            }
            return byArray;
        }
        return null;
    }

    public static PrivateKey getPrivateKeyFrom16(String key) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        Object object;
        try {
            object = RSAUtil.hex2Byte(key);
        }
        catch (Exception exception) {
            exception.getMessage();
            return null;
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = pKCS8EncodedKeySpec;
        pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
        return KeyFactory.getInstance(ALGORITHM_KEY).generatePrivate(pKCS8EncodedKeySpec2);
    }

    public static String byte2Hex(byte[] bytes) {
        byte[] byArray;
        StringBuilder stringBuilder;
        if (bytes == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder2.append(Integer.toString((byArray[i2] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder2.toString();
    }

    @Deprecated
    public static PublicKey getPublicKey(String key) {
        X509EncodedKeySpec x509EncodedKeySpec;
        Object object = Base64Util.decode(key.getBytes(StandardCharsets.UTF_8));
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
            return KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(x509EncodedKeySpec2);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return null;
    }

    public static String getPrivateKeyStr(PrivateKey key) throws Exception {
        return RSAUtil.byte2Hex(key.getEncoded());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verify(String content, PublicKey publicKey, String sign) {
        void var2_2;
        String string;
        void var1_1;
        Signature signature;
        try {
            signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        signature.initVerify((PublicKey)var1_1);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        return signature.verify(RSAUtil.hex2Byte((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] formatPublicKeyPKCS1ToPKCS8(byte[] pkcs1PublicKeyByte) {
        Object object;
        block8: {
            void var0_3;
            RSAPublicKeySpec rSAPublicKeySpec;
            Object object2;
            if (pkcs1PublicKeyByte instanceof a) {
                object2 = (a)object2;
            } else if (object2 != null) {
                a a2;
                object = a2;
                a2 = new a(s.a(object2));
                object2 = object;
            } else {
                object2 = null;
            }
            object = null;
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_KEY);
            RSAPublicKeySpec rSAPublicKeySpec2 = rSAPublicKeySpec;
            RSAPublicKeySpec rSAPublicKeySpec3 = rSAPublicKeySpec;
            Object object3 = object2;
            object2 = object2.a;
            try {
                rSAPublicKeySpec2((BigInteger)object2, object3.b);
                object = keyFactory.generatePublic(rSAPublicKeySpec3).getEncoded();
                break block8;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            var0_3.printStackTrace();
        }
        return object;
    }
}

