/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapsdkplatform.comapi.util.CoordTrans;

public class CoordinateConverter {
    private LatLng a;
    private CoordType b;

    public CoordinateConverter coord(LatLng srcCoord) {
        this.a = srcCoord;
        return this;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.b = coordType;
        return this;
    }

    public LatLng convert() {
        if (this.a == null) {
            return null;
        }
        if (this.b == null) {
            this.b = CoordType.GPS;
        }
        switch (this.b) {
            case COMMON: {
                return CoordinateConverter.b(this.a);
            }
            case GPS: {
                return CoordinateConverter.a(this.a);
            }
            case BD09LL: {
                return CoordinateConverter.d(this.a);
            }
            case BD09MC: {
                return CoordinateConverter.c(this.a);
            }
        }
        return null;
    }

    private static LatLng a(LatLng ptWgs84) {
        return CoordinateConverter.a(ptWgs84, "wgs84");
    }

    private static LatLng b(LatLng ptGcj) {
        return CoordinateConverter.a(ptGcj, "gcj02");
    }

    private static LatLng c(LatLng baiduMc) {
        return CoordinateConverter.a(baiduMc, "bd09mc");
    }

    private static LatLng a(LatLng pt, String bType) {
        if (pt == null) {
            return null;
        }
        float x2 = (float)pt.longitude;
        float y2 = (float)pt.latitude;
        return CoordUtil.Coordinate_encryptEx(x2, y2, bType);
    }

    private static LatLng d(LatLng coord) {
        if (null == coord) {
            return null;
        }
        return CoordTrans.baiduToGcj(coord);
    }

    public static enum CoordType {
        GPS,
        COMMON,
        BD09LL,
        BD09MC;

    }
}

