/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.navi;

import android.text.TextUtils;
import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.navi.WayPoint;
import com.baidu.mapapi.navi.WayPointInfo;
import com.baidu.mapsdkplatform.comapi.util.CoordTrans;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NaviParaOption {
    LatLng a;
    String b;
    String c;
    LatLng d;
    String e;
    String f;
    WayPoint g;
    NaviRoutePolicy h = NaviRoutePolicy.DEFAULT;

    public NaviParaOption setNaviRoutePolicy(NaviRoutePolicy naviRoutePolicy) {
        this.h = naviRoutePolicy;
        return this;
    }

    public String getNaviRoutePolicy() {
        switch (this.h) {
            case BLK: {
                return "BLK";
            }
            case TIME: {
                return "TIME";
            }
            case DIS: {
                return "DIS";
            }
            case FEE: {
                return "FEE";
            }
            case HIGHWAY: {
                return "HIGHWAY";
            }
        }
        return "DEFAULT";
    }

    public NaviParaOption setWayPoint(WayPoint wayPoint) {
        if (null == wayPoint) {
            return null;
        }
        this.g = wayPoint;
        return this;
    }

    public JSONArray getWayPoint() {
        if (null == this.g) {
            return null;
        }
        List<WayPointInfo> viaPoints = this.g.getViaPoints();
        if (null == viaPoints || viaPoints.size() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        for (int i2 = 0; i2 < viaPoints.size(); ++i2) {
            WayPointInfo wayPointInfo = viaPoints.get(i2);
            if (null == wayPointInfo) continue;
            try {
                LatLng wayPoint;
                String name = wayPointInfo.getWayPointName();
                if (!TextUtils.isEmpty((CharSequence)name)) {
                    jsonObject.put("name", (Object)wayPointInfo.getWayPointName());
                }
                if (null == (wayPoint = wayPointInfo.getLatLng())) continue;
                if (SDKInitializer.getCoordType() == CoordType.GCJ02) {
                    wayPoint = CoordTrans.gcjToBaidu(wayPoint);
                }
                jsonObject.put("lng", wayPoint.longitude);
                jsonObject.put("lat", wayPoint.latitude);
                jsonArray.put((Object)jsonObject);
                continue;
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        return jsonArray;
    }

    public NaviParaOption startPoint(LatLng startPoint) {
        this.a = startPoint;
        return this;
    }

    public NaviParaOption startName(String startName) {
        this.b = startName;
        return this;
    }

    public NaviParaOption startUid(String startUid) {
        this.c = startUid;
        return this;
    }

    public NaviParaOption endPoint(LatLng endPoint) {
        this.d = endPoint;
        return this;
    }

    public NaviParaOption endName(String endName) {
        this.e = endName;
        return this;
    }

    public NaviParaOption endUid(String endUid) {
        this.f = endUid;
        return this;
    }

    public LatLng getStartPoint() {
        return this.a;
    }

    public String getStartUid() {
        return this.c;
    }

    public String getEndUid() {
        return this.f;
    }

    public LatLng getEndPoint() {
        return this.d;
    }

    public String getStartName() {
        return this.b;
    }

    public String getEndName() {
        return this.e;
    }

    public static enum NaviRoutePolicy {
        BLK,
        TIME,
        DIS,
        FEE,
        HIGHWAY,
        DEFAULT;

    }
}

