/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.mapapi.map.BaseBackgroundDrawLayer;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import org.json.JSONException;
import org.json.JSONObject;

abstract class u<T>
extends BaseBackgroundDrawLayer {
    protected T mEntity;
    protected MapController mController;

    u(Context context) {
        super(context);
    }

    u(Context context, int order) {
        super(context, order);
    }

    public final void updateEntity(T t2) {
        this.mEntity = t2;
    }

    public final void updateMapController(MapController controller) {
        this.mController = controller;
    }

    public final void toScreenLocation(LatLng position, Point target) {
        if (position == null) {
            return;
        }
        GeoPoint gp = CoordUtil.ll2mc(position);
        this.toScreenLocation((int)gp.getLongitude(), (int)gp.getLatitude(), target);
    }

    public final void toScreenLocation(int x2, int y2, Point target) {
        if (target == null) {
            return;
        }
        MapController controller = this.mController;
        if (controller == null) {
            target.setTo(-1.0, -1.0);
            return;
        }
        AppBaseMap baseMap = controller.getBaseMap();
        if (baseMap == null) {
            target.setTo(-1.0, -1.0);
            return;
        }
        String json = baseMap.GeoPtToScrPoint(x2, y2);
        if (TextUtils.isEmpty((CharSequence)json)) {
            target.setTo(-1.0, -1.0);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            target.setIntX(jsonObject.optInt("scrx", -1));
            target.setIntY(jsonObject.optInt("scry", -1));
        }
        catch (JSONException e2) {
            target.setTo(-1.0, -1.0);
        }
    }
}

