/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Point;
import android.graphics.PointF;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapsdkplatform.comapi.map.c;
import com.baidu.mapsdkplatform.comapi.map.x;
import com.baidu.platform.comapi.basestruct.GeoPoint;

public final class Projection {
    private c a;

    Projection(c baseMap) {
        this.a = baseMap;
    }

    public LatLng fromScreenLocation(Point point) {
        if (point != null && this.a != null) {
            GeoPoint gp = this.a.b(point.x, point.y);
            return CoordUtil.mc2ll(gp);
        }
        return null;
    }

    public Point toScreenLocation(LatLng location) {
        if (location != null && this.a != null) {
            GeoPoint gp = CoordUtil.ll2mc(location);
            return this.a.a(gp);
        }
        return null;
    }

    public Point geoPoint3toScreenLocation(LatLng location, int height) {
        if (location != null && this.a != null && height >= 0) {
            GeoPoint gp = CoordUtil.ll2mc(location);
            return this.a.a(gp, height);
        }
        return null;
    }

    public PointF toOpenGLLocation(LatLng location, MapStatus mapStatus) {
        if (null == location || null == mapStatus) {
            return null;
        }
        GeoPoint gp = CoordUtil.ll2mc(location);
        x msi = mapStatus.a;
        double x2 = msi.d;
        double y2 = msi.e;
        return new PointF((float)(gp.getLongitudeE6() - x2), (float)(gp.getLatitudeE6() - y2));
    }

    public PointF toOpenGLNormalization(LatLng location, MapStatus mapStatus) {
        if (null == location || null == mapStatus) {
            return null;
        }
        GeoPoint gp = CoordUtil.ll2mc(location);
        x msi = mapStatus.a;
        x.a geoBound = msi.k;
        double width = Math.abs(geoBound.b - geoBound.a);
        double height = Math.abs(geoBound.c - geoBound.d);
        double x2 = 2.0 * (gp.getLongitudeE6() - (double)geoBound.a) / width - 1.0;
        double y2 = 2.0 * (gp.getLatitudeE6() - (double)geoBound.d) / height - 1.0;
        return new PointF((float)x2, (float)y2);
    }

    public float metersToEquatorPixels(float meters) {
        if (meters <= 0.0f) {
            return 0.0f;
        }
        return (float)((double)meters / this.a.N());
    }
}

