/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.CircleHoleOptions;
import com.baidu.mapapi.map.EncodePointType;
import com.baidu.mapapi.map.HoleOptions;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.OverlayUtil;
import com.baidu.mapapi.map.PolygonHoleOptions;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.map.h;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.bmsdk.BmDrawItem;
import com.baidu.platform.comapi.bmsdk.BmLayer;
import com.baidu.platform.comapi.bmsdk.b;
import com.baidu.platform.comapi.bmsdk.style.BmBitmapResource;
import com.baidu.platform.comapi.bmsdk.style.BmLineStyle;
import java.util.ArrayList;
import java.util.List;

public abstract class Overlay {
    String K = System.currentTimeMillis() + "_" + this.hashCode();
    EncodePointType L;
    public h type;
    int M;
    boolean N;
    Bundle O;
    protected BmDrawItem mDrawItem;
    protected static GeoPoint mcLocation;
    BmLayer P;
    protected a listener;

    protected Overlay() {
    }

    public void setBmLayer(BmLayer bmLayer) {
        this.P = bmLayer;
    }

    public BmLayer getBmLayer() {
        return this.P;
    }

    public String getName() {
        return this.K;
    }

    public BmDrawItem getDrawItem() {
        return this.mDrawItem;
    }

    public void setDrawItem(BmDrawItem mDrawItem) {
        this.mDrawItem = mDrawItem;
    }

    public boolean isVisible() {
        return this.N;
    }

    public void setVisible(boolean visible) {
        this.N = visible;
        if (this instanceof Marker) {
            this.listener.c(this);
            return;
        }
        if (OverlayUtil.isOverlayUpgrade()) {
            if (this.P != null && this.mDrawItem != null) {
                this.mDrawItem.i(visible ? 1 : 0);
                this.P.c();
            }
        } else {
            this.listener.c(this);
        }
    }

    public int getZIndex() {
        return this.M;
    }

    public void setZIndex(int zIndex) {
        this.M = zIndex;
        this.listener.c(this);
    }

    public Bundle getExtraInfo() {
        return this.O;
    }

    public void setExtraInfo(Bundle extraInfo) {
        this.O = extraInfo;
    }

    Bundle a(Bundle b2) {
        b2.putString("id", this.K);
        b2.putInt("type", this.type.ordinal());
        b2.putInt("visibility", this.N ? 1 : 0);
        b2.putInt("z_index", this.M);
        return b2;
    }

    Bundle a() {
        Bundle b2 = new Bundle();
        b2.putString("id", this.K);
        b2.putInt("type", this.type.ordinal());
        return b2;
    }

    BmDrawItem b() {
        if (this.mDrawItem != null) {
            this.mDrawItem.i(this.N ? 1 : 0);
            this.mDrawItem.a((short)this.M);
        }
        return this.mDrawItem;
    }

    BmDrawItem toDrawItem() {
        if (this.mDrawItem == null) {
            return null;
        }
        this.mDrawItem.setName(this.getName());
        this.mDrawItem.i(this.N ? 1 : 0);
        this.mDrawItem.a((short)this.M);
        return this.mDrawItem;
    }

    public LatLngBounds getOverlayLatLngBounds() {
        return this.listener.a(this);
    }

    public void remove() {
        if (this instanceof Marker) {
            this.listener.b(this);
            return;
        }
        if (OverlayUtil.isOverlayUpgrade()) {
            if (this.P != null && this.mDrawItem != null) {
                this.P.a(this.mDrawItem);
                this.mDrawItem = null;
                this.P.c();
            }
        } else {
            this.listener.b(this);
        }
    }

    public boolean isRemoved() {
        if (this instanceof Marker) {
            return this.listener.d(this);
        }
        if (OverlayUtil.isOverlayUpgrade()) {
            if (this.P != null) {
                BmDrawItem item = this.P.a(this.getName());
                return item == null;
            }
            return true;
        }
        return this.listener.d(this);
    }

    static void a(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("color", colorBundle);
    }

    static void a(List<LatLng> points, Bundle b2) {
        int length = points.size();
        double[] xArray = new double[length];
        double[] yArray = new double[length];
        for (int i2 = 0; i2 < length; ++i2) {
            GeoPoint gp = CoordUtil.ll2mc(points.get(i2));
            xArray[i2] = gp.getLongitudeE6();
            yArray[i2] = gp.getLatitudeE6();
        }
        b2.putDoubleArray("x_array", xArray);
        b2.putDoubleArray("y_array", yArray);
    }

    static boolean b(List<HoleOptions> holeOptionsList, Bundle b2) {
        if (holeOptionsList == null || holeOptionsList.size() == 0) {
            return false;
        }
        ArrayList<CircleHoleOptions> circleHoleOptions = new ArrayList<CircleHoleOptions>();
        ArrayList<PolygonHoleOptions> polygonHoleOptions = new ArrayList<PolygonHoleOptions>();
        for (HoleOptions holeOptions : holeOptionsList) {
            if (holeOptions instanceof CircleHoleOptions) {
                circleHoleOptions.add((CircleHoleOptions)holeOptions);
                continue;
            }
            if (!(holeOptions instanceof PolygonHoleOptions)) continue;
            polygonHoleOptions.add((PolygonHoleOptions)holeOptions);
        }
        boolean hasCircleHole = false;
        if (circleHoleOptions.size() != 0) {
            hasCircleHole = Overlay.c(circleHoleOptions, b2);
            b2.putInt("has_circle_hole", hasCircleHole ? 1 : 0);
        } else {
            b2.putInt("has_circle_hole", 0);
        }
        boolean hasPolygonHole = false;
        if (polygonHoleOptions.size() != 0) {
            hasPolygonHole = Overlay.d(polygonHoleOptions, b2);
            b2.putInt("has_polygon_hole", hasPolygonHole ? 1 : 0);
        } else {
            b2.putInt("has_polygon_hole", 0);
        }
        return hasCircleHole || hasPolygonHole;
    }

    private static boolean c(List<CircleHoleOptions> circleHoleOptions, Bundle b2) {
        int length = circleHoleOptions.size();
        double[] centerXArray = new double[length];
        double[] centerYArray = new double[length];
        int[] radiusArray = new int[length];
        int[] holeIndexArray = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            LatLng center = circleHoleOptions.get(i2).getHoleCenter();
            int radius = circleHoleOptions.get(i2).getHoleRadius();
            if (center == null || radius <= 0) {
                return false;
            }
            GeoPoint gp = CoordUtil.ll2mc(center);
            centerXArray[i2] = gp.getLongitudeE6();
            centerYArray[i2] = gp.getLatitudeE6();
            radiusArray[i2] = radius;
            holeIndexArray[i2] = i2;
        }
        b2.putDoubleArray("circle_hole_x_array", centerXArray);
        b2.putDoubleArray("circle_hole_y_array", centerYArray);
        b2.putIntArray("circle_hole_radius_array", radiusArray);
        b2.putIntArray("circle_hole_index_array", holeIndexArray);
        return true;
    }

    public static List<List<b>> holeInfo2BmGeo(List<HoleOptions> holeOptionsList) {
        if (holeOptionsList == null || holeOptionsList.size() == 0) {
            return null;
        }
        ArrayList<List<b>> bmMCPointLs = new ArrayList<List<b>>();
        ArrayList<CircleHoleOptions> circleHoleOptions = new ArrayList<CircleHoleOptions>();
        ArrayList<PolygonHoleOptions> polygonHoleOptions = new ArrayList<PolygonHoleOptions>();
        for (HoleOptions holeOptions : holeOptionsList) {
            if (holeOptions instanceof CircleHoleOptions) {
                circleHoleOptions.add((CircleHoleOptions)holeOptions);
                continue;
            }
            if (!(holeOptions instanceof PolygonHoleOptions)) continue;
            polygonHoleOptions.add((PolygonHoleOptions)holeOptions);
        }
        if (circleHoleOptions.size() != 0) {
            bmMCPointLs.addAll(Overlay.circleHoleInfo2BmGeo(circleHoleOptions));
        }
        if (polygonHoleOptions.size() != 0) {
            bmMCPointLs.addAll(Overlay.polygonHoleInfo2BmGeo(polygonHoleOptions));
        }
        return bmMCPointLs;
    }

    public static List<List<b>> circleHoleInfo2BmGeo(List<CircleHoleOptions> circleHoleOptions) {
        int length = circleHoleOptions.size();
        double[] centerXArray = new double[length];
        double[] centerYArray = new double[length];
        int[] radiusArray = new int[length];
        int[] holeIndexArray = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            LatLng center = circleHoleOptions.get(i2).getHoleCenter();
            int radius = circleHoleOptions.get(i2).getHoleRadius();
            if (center == null || radius <= 0) {
                return null;
            }
            GeoPoint gp = CoordUtil.ll2mc(center);
            centerXArray[i2] = gp.getLongitudeE6();
            centerYArray[i2] = gp.getLatitudeE6();
            radiusArray[i2] = radius;
            holeIndexArray[i2] = i2;
        }
        ArrayList<List<b>> m_arrDesCoords = new ArrayList<List<b>>();
        for (int i3 = 0; i3 < radiusArray.length; ++i3) {
            double centerPoint_x = centerXArray[i3];
            double centerPoint_y = centerYArray[i3];
            int num_steps = 360;
            ArrayList<b> pPoints = new ArrayList<b>();
            for (int step = 0; step < num_steps; ++step) {
                double fAngle = (double)step * Math.PI * 2.0 / (double)num_steps;
                double point_x = Math.cos(fAngle) * (double)radiusArray[i3] + (centerPoint_x - mcLocation.getLongitudeE6());
                double point_y = Math.sin(fAngle) * (double)radiusArray[i3] + (centerPoint_y - mcLocation.getLatitudeE6());
                pPoints.add(new b(point_x + mcLocation.getLongitudeE6(), point_y + mcLocation.getLatitudeE6()));
            }
            int holeIndex = holeIndexArray[i3];
            m_arrDesCoords.add(pPoints);
        }
        return m_arrDesCoords;
    }

    protected void setDottedBitmapResource(BmLineStyle lineStyle, int dottedStrokeType) {
        if (lineStyle == null) {
            return;
        }
        String dottedResName = "lineDashTexture.png";
        int lineType = 1;
        if (dottedStrokeType == 1) {
            dottedResName = "CircleDashTexture.png";
            lineType = 2;
        }
        lineStyle.d(lineType);
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromAsset(dottedResName);
        if (bitmapDescriptor != null) {
            lineStyle.a(new BmBitmapResource(bitmapDescriptor.getBitmap()));
        }
    }

    public static List<List<b>> polygonHoleInfo2BmGeo(List<PolygonHoleOptions> polygonHoleOptions) {
        int polygonCount = polygonHoleOptions.size();
        int[] polygonCountArray = new int[polygonCount];
        int[] holeIndexArray = new int[polygonCount];
        ArrayList<LatLng> allHolePoints = new ArrayList<LatLng>();
        ArrayList<List<b>> m_arrDesCoords = new ArrayList<List<b>>();
        for (int i2 = 0; i2 < polygonCount; ++i2) {
            List<LatLng> holePoints = polygonHoleOptions.get(i2).getHolePoints();
            if (holePoints == null) {
                return null;
            }
            ArrayList<b> bmMCPointList = new ArrayList<b>();
            for (LatLng latLng : holePoints) {
                GeoPoint geoPoint = CoordUtil.ll2mc(latLng);
                bmMCPointList.add(new b(geoPoint.getLongitudeE6(), geoPoint.getLatitudeE6()));
            }
            allHolePoints.addAll(holePoints);
            polygonCountArray[i2] = holePoints.size();
            holeIndexArray[i2] = i2;
            m_arrDesCoords.add(bmMCPointList);
        }
        return m_arrDesCoords;
    }

    private static boolean d(List<PolygonHoleOptions> polygonHoleOptions, Bundle b2) {
        int polygonCount = polygonHoleOptions.size();
        int[] polygonCountArray = new int[polygonCount];
        int[] holeIndexArray = new int[polygonCount];
        ArrayList<LatLng> allHolePoints = new ArrayList<LatLng>();
        for (int i2 = 0; i2 < polygonCount; ++i2) {
            List<LatLng> holePoints = polygonHoleOptions.get(i2).getHolePoints();
            if (holePoints == null) {
                return false;
            }
            allHolePoints.addAll(holePoints);
            polygonCountArray[i2] = holePoints.size();
            holeIndexArray[i2] = i2;
        }
        int pointTotalSize = allHolePoints.size();
        if (pointTotalSize == 0) {
            return false;
        }
        b2.putIntArray("polygon_hole_count_array", polygonCountArray);
        b2.putIntArray("polygon_hole_index_array", holeIndexArray);
        double[] xArray = new double[pointTotalSize];
        double[] yArray = new double[pointTotalSize];
        for (int j2 = 0; j2 < pointTotalSize; ++j2) {
            GeoPoint gp = CoordUtil.ll2mc((LatLng)allHolePoints.get(j2));
            xArray[j2] = gp.getLongitudeE6();
            yArray[j2] = gp.getLatitudeE6();
        }
        b2.putDoubleArray("polygon_hole_x_array", xArray);
        b2.putDoubleArray("polygon_hole_y_array", yArray);
        return true;
    }

    static void b(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_floorColor", colorBundle);
    }

    static void c(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_topFaceColor", colorBundle);
    }

    static void d(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_sideFaceColor", colorBundle);
    }

    static void e(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_center_color", colorBundle);
    }

    static void f(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_side_color", colorBundle);
    }

    static interface a {
        public void b(Overlay var1);

        public void c(Overlay var1);

        public boolean d(Overlay var1);

        public LatLngBounds a(Overlay var1);
    }
}

