/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Point;
import android.util.Log;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.map.c;
import com.baidu.platform.comapi.basestruct.GeoPoint;

public final class MapStatusUpdate {
    private static final String o = MapStatusUpdate.class.getSimpleName();
    private int p;
    MapStatus a;
    LatLng b;
    LatLngBounds c;
    int d;
    int e;
    float f;
    int g;
    int h;
    float i;
    Point j;
    int k = 0;
    int l = 0;
    int m = 0;
    int n = 0;

    private MapStatusUpdate() {
    }

    MapStatusUpdate(int commandCode) {
        this.p = commandCode;
    }

    MapStatus a(c baseMap, MapStatus oldStatus) {
        if (null == baseMap || null == oldStatus) {
            return null;
        }
        switch (this.p) {
            case 1: {
                return this.a;
            }
            case 2: {
                return new MapStatus(oldStatus.rotate, this.b, oldStatus.overlook, oldStatus.zoom, oldStatus.targetScreen, null);
            }
            case 3: {
                if (null == this.c) {
                    return null;
                }
                double l2 = 0.0;
                double t2 = 0.0;
                double r2 = 0.0;
                double b2 = 0.0;
                GeoPoint southwest = CoordUtil.ll2mc(this.c.southwest);
                GeoPoint northeast = CoordUtil.ll2mc(this.c.northeast);
                l2 = southwest.getLongitudeE6();
                t2 = northeast.getLatitudeE6();
                r2 = northeast.getLongitudeE6();
                b2 = southwest.getLatitudeE6();
                float zoom = baseMap.a((int)l2, (int)t2, (int)r2, (int)b2, oldStatus.a.j.right - oldStatus.a.j.left, oldStatus.a.j.bottom - oldStatus.a.j.top);
                LatLng center = this.c.getCenter();
                return new MapStatus(oldStatus.rotate, center, oldStatus.overlook, zoom, oldStatus.targetScreen, null);
            }
            case 4: {
                return new MapStatus(oldStatus.rotate, this.b, oldStatus.overlook, this.f, oldStatus.targetScreen, null);
            }
            case 5: {
                int x2 = baseMap.K() / 2 + this.g;
                int y2 = baseMap.L() / 2 + this.h;
                GeoPoint gp = baseMap.b(x2, y2);
                LatLng latlng = CoordUtil.mc2ll(gp);
                return new MapStatus(oldStatus.rotate, latlng, oldStatus.overlook, oldStatus.zoom, oldStatus.targetScreen, gp.getLongitudeE6(), gp.getLatitudeE6(), null);
            }
            case 6: {
                return new MapStatus(oldStatus.rotate, oldStatus.target, oldStatus.overlook, oldStatus.zoom + this.i, oldStatus.targetScreen, oldStatus.a(), oldStatus.b(), null);
            }
            case 7: {
                GeoPoint point = baseMap.b(this.j.x, this.j.y);
                LatLng target = CoordUtil.mc2ll(point);
                return new MapStatus(oldStatus.rotate, target, oldStatus.overlook, oldStatus.zoom + this.i, this.j, null);
            }
            case 8: {
                return new MapStatus(oldStatus.rotate, oldStatus.target, oldStatus.overlook, this.f, oldStatus.targetScreen, oldStatus.a(), oldStatus.b(), null);
            }
            case 9: {
                double ll = 0.0;
                double tt = 0.0;
                double rr = 0.0;
                double bb = 0.0;
                if (null == this.c) {
                    return null;
                }
                GeoPoint sw = CoordUtil.ll2mc(this.c.southwest);
                GeoPoint ne = CoordUtil.ll2mc(this.c.northeast);
                ll = sw.getLongitudeE6();
                tt = ne.getLatitudeE6();
                rr = ne.getLongitudeE6();
                bb = sw.getLatitudeE6();
                float zzoom = baseMap.a((int)ll, (int)tt, (int)rr, (int)bb, this.d, this.e);
                LatLng ccenter = this.c.getCenter();
                return new MapStatus(oldStatus.rotate, ccenter, oldStatus.overlook, zzoom, oldStatus.targetScreen, null);
            }
            case 11: {
                int height;
                if (null == this.c) {
                    return null;
                }
                int width = baseMap.K() - this.k - this.m;
                if (width < 0) {
                    width = baseMap.K();
                    Log.e((String)o, (String)"Bound paddingLeft or paddingRight too larger, please check");
                }
                if ((height = baseMap.L() - this.l - this.n) < 0) {
                    height = baseMap.L();
                    Log.e((String)o, (String)"Bound paddingTop or paddingBottom too larger, please check");
                }
                GeoPoint swsw = CoordUtil.ll2mc(this.c.southwest);
                GeoPoint nene = CoordUtil.ll2mc(this.c.northeast);
                double lll = swsw.getLongitudeE6();
                double ttt = nene.getLatitudeE6();
                double rrr = nene.getLongitudeE6();
                double bbb = swsw.getLatitudeE6();
                float zzzoom = baseMap.a((int)lll, (int)ttt, (int)rrr, (int)bbb, width, height);
                int screenx = this.k + width / 2;
                int screeny = this.l + height / 2;
                Point targetScreen = new Point(screenx, screeny);
                LatLng cccenter = this.c.getCenter();
                return new MapStatus(oldStatus.rotate, cccenter, oldStatus.overlook, zzzoom, targetScreen, null);
            }
            case 10: {
                float zoomValue;
                float currentZoomUnit;
                LatLng newCenter;
                int newHeight;
                if (null == this.c) {
                    return null;
                }
                int newWidth = baseMap.K() - this.k - this.m;
                if (newWidth < 0) {
                    newWidth = baseMap.K();
                    Log.e((String)o, (String)"Bound paddingLeft or paddingRight too larger, please check");
                }
                if ((newHeight = baseMap.L() - this.l - this.n) < 0) {
                    newHeight = baseMap.L();
                    Log.e((String)o, (String)"Bound paddingTop or paddingBottom too larger, please check");
                }
                if (null == (newCenter = this.a(this.c, baseMap, currentZoomUnit = this.a(zoomValue = this.a(this.c, baseMap, newWidth, newHeight))))) {
                    Log.e((String)o, (String)"Bound center error");
                    return null;
                }
                MapStatus mapStatus = null;
                boolean isBoundChange = this.a(this.c, baseMap);
                boolean isPaddingChange = this.a(this.k, this.l, this.m, this.n, baseMap);
                if (isBoundChange || isPaddingChange) {
                    mapStatus = new MapStatus(oldStatus.rotate, newCenter, oldStatus.overlook, zoomValue, null, null);
                    baseMap.a(this.a(mapStatus));
                } else if (null != baseMap.I()) {
                    mapStatus = baseMap.I().a;
                }
                return mapStatus;
            }
        }
        return null;
    }

    private float a(LatLngBounds newBounds, c baseMap, int newWidth, int newHeight) {
        GeoPoint southwestGeoPoint = CoordUtil.ll2mc(newBounds.southwest);
        GeoPoint northeastGeoPoint = CoordUtil.ll2mc(newBounds.northeast);
        int southwestLongitude = (int)southwestGeoPoint.getLongitudeE6();
        int southwestLatitude = (int)southwestGeoPoint.getLatitudeE6();
        int northeastLongitude = (int)northeastGeoPoint.getLongitudeE6();
        int northeastLatitude = (int)northeastGeoPoint.getLatitudeE6();
        float zoomValue = baseMap.a(southwestLongitude, northeastLatitude, northeastLongitude, southwestLatitude, newWidth, newHeight);
        return zoomValue;
    }

    private boolean a(LatLngBounds newBounds, c baseMap) {
        MapStatusUpdate lastMapStatusUpdate = baseMap.I();
        if (null == lastMapStatusUpdate) {
            return true;
        }
        double newBoundsSourthEastLat = newBounds.southwest.latitude;
        double newBoundsSourthEastLng = newBounds.southwest.longitude;
        double newBoundsNorthWestLat = newBounds.northeast.latitude;
        double newBoundsNorthWestLng = newBounds.northeast.longitude;
        double oldBoundsSourthEastLat = lastMapStatusUpdate.c.southwest.latitude;
        double oldBoundsSourthEastLng = lastMapStatusUpdate.c.southwest.longitude;
        double oldBoundsNorthWestLat = lastMapStatusUpdate.c.northeast.latitude;
        double oldBoundsNorthWestLng = lastMapStatusUpdate.c.northeast.longitude;
        return newBoundsSourthEastLat != oldBoundsSourthEastLat || newBoundsSourthEastLng != oldBoundsSourthEastLng || newBoundsNorthWestLat != oldBoundsNorthWestLat || newBoundsNorthWestLng != oldBoundsNorthWestLng;
    }

    private boolean a(int left, int top, int right, int bottom, c baseMapInner) {
        MapStatusUpdate lastMapStatusUpdate = baseMapInner.I();
        if (null == lastMapStatusUpdate) {
            return true;
        }
        return left != lastMapStatusUpdate.k || top != lastMapStatusUpdate.l || right != lastMapStatusUpdate.m || bottom != lastMapStatusUpdate.n;
    }

    private LatLng a(LatLngBounds newBounds, c baseMap, float currentZoomUnit) {
        if (null == newBounds || null == baseMap) {
            return null;
        }
        GeoPoint oldCenterGeoPoint = CoordUtil.ll2mc(newBounds.getCenter());
        double targetZoomPaddingLeft = (float)this.k * currentZoomUnit;
        double targetZoomPaddingRight = (float)this.m * currentZoomUnit;
        double targetZoomPaddingTop = (float)this.l * currentZoomUnit;
        double targetZoomPaddingBottom = (float)this.n * currentZoomUnit;
        double newCenterGeoPointLong = this.k > this.m ? oldCenterGeoPoint.getLongitudeE6() - (targetZoomPaddingLeft - targetZoomPaddingRight) / 2.0 : (this.k < this.m ? oldCenterGeoPoint.getLongitudeE6() + (targetZoomPaddingRight - targetZoomPaddingLeft) / 2.0 : oldCenterGeoPoint.getLongitudeE6());
        double newCenterGeoPointLat = this.l < this.n ? oldCenterGeoPoint.getLatitudeE6() - (targetZoomPaddingBottom - targetZoomPaddingTop) / 2.0 + targetZoomPaddingTop / 2.0 : (this.l > this.n ? oldCenterGeoPoint.getLatitudeE6() + (targetZoomPaddingTop - targetZoomPaddingBottom) / 2.0 : oldCenterGeoPoint.getLatitudeE6());
        GeoPoint newCenterGeoPoint = new GeoPoint(newCenterGeoPointLat, newCenterGeoPointLong);
        return CoordUtil.mc2ll(newCenterGeoPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapStatusUpdate a(MapStatus mapStatus) {
        MapStatusUpdate mapStatusUpdate = new MapStatusUpdate();
        MapStatusUpdate mapStatusUpdate2 = this;
        synchronized (mapStatusUpdate2) {
            mapStatusUpdate.a = mapStatus;
            mapStatusUpdate.c = this.c;
            mapStatusUpdate.k = this.k;
            mapStatusUpdate.l = this.l;
            mapStatusUpdate.m = this.m;
            mapStatusUpdate.n = this.n;
        }
        return mapStatusUpdate;
    }

    private float a(float level) {
        int densityDpi = SysOSUtil.getDensityDpi();
        float densityDpiScal = (float)densityDpi / 310.0f;
        return (float)(Math.pow(2.0, 18.0f - level) / (double)densityDpiScal);
    }
}

