/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Color;
import android.os.Bundle;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.HexagonMapData;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.y;
import com.baidu.mapapi.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;

public class HexagonMap {
    public static final int DEFAULT_MAX_HIGH = 0;
    public static final int DEFAULT_MIN_LEVEL = 4;
    public static final int DEFAULT_MAX_LEVEL = 22;
    private Collection<WeightedLatLng> a;
    private float b;
    private float c;
    private HexagonType d;
    private float e;
    private float f;
    private float g;
    private Gradient h;
    private int i;
    private int j;
    private int[] k;
    private float[] l;
    protected a hexagonMapLayerListener;
    private static final int[] m = new int[]{Color.rgb((int)0, (int)0, (int)250), Color.rgb((int)0, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
    private static final float[] n = new float[]{0.0f, 0.5f, 1.0f};
    public static final Gradient DEFAULT_GRADIENT = new Gradient(m, n);

    private HexagonMap(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.d;
        this.d = builder.c;
        this.h = builder.e;
        this.i = builder.h;
        this.j = builder.i;
        this.f = builder.j;
        this.g = builder.k;
        this.e = builder.f;
        this.a(this.h);
    }

    private void a(Gradient gradient) {
        this.h = gradient;
        this.k = gradient.a(this.e);
        this.l = gradient.a();
    }

    private static Collection<WeightedLatLng> b(Collection<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    public void remove() {
        if (this.a != null) {
            this.a.clear();
        }
        this.hexagonMapLayerListener.a(this);
    }

    public void setShow(boolean isShow) {
        this.hexagonMapLayerListener.a(this, isShow);
    }

    public Bundle toBundle() {
        Bundle b2 = new Bundle();
        b2.putFloat("radius", this.b);
        b2.putFloat("gap", this.c);
        b2.putFloat("alpha", this.e);
        HexagonMapData hexagonData = new HexagonMapData(this.a, this.f);
        hexagonData.toBundle(b2);
        b2.putIntArray("color_array", this.k);
        b2.putInt("hexagon_type", this.d.ordinal());
        b2.putFloatArray("color_start_points", this.l);
        b2.putFloat("max_intentity", this.f);
        b2.putFloat("min_intentity", this.g);
        b2.putFloat("max_show_level", (float)this.i);
        b2.putFloat("min_show_level", (float)this.j);
        return b2;
    }

    /* synthetic */ HexagonMap(Builder x02, y x1) {
        this(x02);
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private float b = 200.0f;
        private HexagonType c = HexagonType.VERTEX_UP;
        private float d = 5.0f;
        private Gradient e = DEFAULT_GRADIENT;
        private float f = 1.0f;
        private int g = 0;
        private int h = 22;
        private int i = 4;
        private float j = 1.0f;
        private float k = 0.0f;

        public Builder maxIntensity(float intensity) {
            if (intensity < 0.0f || intensity <= this.k) {
                return this;
            }
            this.j = intensity;
            return this;
        }

        public Builder minIntensity(float intensity) {
            if (intensity < 0.0f) {
                this.k = 0.0f;
                return this;
            }
            if (intensity >= this.j) {
                return this;
            }
            this.k = intensity;
            return this;
        }

        public Builder hexagonType(HexagonType type) {
            this.c = type;
            return this;
        }

        public Builder gradient(Gradient gradient) {
            if (gradient == null) {
                throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
            }
            this.e = gradient;
            return this;
        }

        public Builder data(Collection<LatLng> data) {
            if (data == null || data.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (data.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            return this.weightedData(HexagonMap.b(data));
        }

        public Builder weightedData(Collection<WeightedLatLng> weightData) {
            if (weightData == null || weightData.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (weightData.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            this.a = weightData;
            return this;
        }

        public Builder maxShowLevel(int maxLevel) {
            if (maxLevel < this.i) {
                return this;
            }
            if (maxLevel > 22) {
                this.h = 22;
            }
            this.h = maxLevel;
            return this;
        }

        public Builder minShowLevel(int minLevel) {
            if (minLevel < 4) {
                this.i = 4;
                return this;
            }
            if (minLevel > this.h) {
                return this;
            }
            this.i = minLevel;
            return this;
        }

        public Builder radius(int radius) {
            if (radius < 0) {
                return this;
            }
            this.b = radius;
            return this;
        }

        public Builder gap(float padding) {
            if (padding < 0.0f) {
                this.d = 0.0f;
                return this;
            }
            this.d = padding;
            return this;
        }

        public Builder opacity(float opacity) {
            if (opacity < 0.0f) {
                this.f = 0.0f;
                return this;
            }
            if (opacity > 1.0f) {
                this.f = 1.0f;
                return this;
            }
            this.f = opacity;
            return this;
        }

        public HexagonMap build() {
            if (this.a == null) {
                throw new IllegalStateException("BDMapSDKException: No input data: you must use either .data or .weightedData before building");
            }
            return new HexagonMap(this, null);
        }
    }

    static interface a {
        public void a(HexagonMap var1);

        public void a(HexagonMap var1, boolean var2);
    }

    public static enum HexagonType {
        VERTEX_UP,
        EDGE_UP;

    }
}

