/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Bundle;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.HeatMapAnimation;
import com.baidu.mapapi.map.HeatMapData;
import com.baidu.mapapi.map.Tile;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.ah;
import com.baidu.mapapi.map.v;
import com.baidu.mapapi.map.x;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.SysOSUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HeatMap {
    private static final String b = HeatMap.class.getSimpleName();
    private static final SparseIntArray c = new SparseIntArray();
    private static final int[] d;
    private static final float[] e;
    public static final int DEFAULT_MAX_HIGH = 0;
    public static final int DEFAULT_MIN_LEVEL = 4;
    public static final int DEFAULT_MAX_LEVEL = 22;
    private int f = 200;
    private boolean g = false;
    private int h = 22;
    private int i = 4;
    private ah<WeightedLatLng> j;
    private Collection<WeightedLatLng> k;
    private List<List<WeightedLatLng>> l;
    private float m;
    private float n;
    protected boolean mIsSetMaxIntensity;
    private HeatMapAnimation o;
    private HeatMapAnimation p;
    private int q;
    private int r;
    private Gradient s;
    private double t;
    private v u;
    private int[] v;
    private float[] w;
    private double[] x;
    private double[] y;
    private List<double[]> z;
    private HashMap<String, Tile> A;
    private ExecutorService B;
    private HashSet<String> C;
    BaiduMap a;
    private int D = SysOSUtil.getInstance().getScreenWidth() / 2;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;
    private static int E;

    public void updateMaxIntensity(float intensity) {
        if (intensity < 0.0f || intensity <= this.n) {
            return;
        }
        this.m = intensity;
    }

    public void updateMinIntensity(float intensity) {
        if (intensity < 0.0f) {
            this.n = 0.0f;
            return;
        }
        if (intensity >= this.m) {
            return;
        }
        this.n = intensity;
    }

    public void updateFrameAnimation(HeatMapAnimation animation) {
        this.o = animation;
    }

    public void updateRadius(int radius) {
        if (radius < 10) {
            this.q = 10;
            return;
        }
        if (radius > 50) {
            this.q = 50;
            return;
        }
        this.q = radius;
    }

    public void updateRadiusMeter(int radius) {
        if (radius < 10) {
            this.r = 10;
            return;
        }
        if (radius > 50) {
            this.r = 50;
            return;
        }
        this.r = radius;
    }

    public void updateMaxHigh(int high) {
        if (high < 0) {
            return;
        }
        if (high > 200) {
            this.f = 200;
            return;
        }
        this.f = high;
    }

    public void updateIsRadiusMeter(boolean isMeter) {
        this.g = isMeter;
    }

    public void updateGradient(Gradient gradient) {
        if (gradient == null) {
            throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
        }
        this.s = gradient;
        this.a(this.s);
    }

    public void updateOpacity(double opacity) {
        if (opacity < 0.0) {
            this.t = 0.0;
            return;
        }
        if (opacity > 1.0) {
            this.t = 1.0;
            return;
        }
        this.t = opacity;
    }

    public void updateMaxShowLevel(int maxLevel) {
        if (maxLevel < this.i) {
            return;
        }
        if (maxLevel > 22) {
            this.h = 22;
            return;
        }
        this.h = maxLevel;
    }

    public void updateMinShowLevel(int minLevel) {
        if (minLevel < 4) {
            this.i = 4;
            return;
        }
        if (minLevel > this.h) {
            return;
        }
        this.i = minLevel;
    }

    public void updateData(Collection<LatLng> data) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }
        if (data.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        this.updateWeightedData(HeatMap.c(data));
    }

    public void updateDatas(List<List<LatLng>> datas) {
        if (datas == null || datas.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input datas.");
        }
        if (datas.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        this.updateWeightedDatas(HeatMap.b(datas));
    }

    public void updateWeightedData(Collection<WeightedLatLng> weightData) {
        if (weightData == null || weightData.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }
        if (weightData.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        this.k = weightData;
    }

    public void updateWeightedDatas(List<List<WeightedLatLng>> weightDatas) {
        if (weightDatas == null || weightDatas.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }
        if (weightDatas.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        this.l = weightDatas;
    }

    private HeatMap(Builder builder) {
        this.A = new HashMap();
        this.B = Executors.newFixedThreadPool(1);
        this.C = new HashSet();
        this.l = builder.b;
        this.q = builder.c;
        this.r = builder.d;
        this.g = builder.h;
        this.h = builder.i;
        this.i = builder.j;
        this.mIsSetMaxIntensity = builder.m;
        if (!this.mIsSetMaxIntensity && this.l != null) {
            this.z = new ArrayList<double[]>();
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                this.k = this.l.get(i2);
                this.u = HeatMap.d(this.k);
                this.z.add(this.a(this.q));
            }
        }
        this.k = builder.a;
        if (!this.mIsSetMaxIntensity && this.k != null) {
            this.b(this.k);
        }
        this.p = builder.n;
        this.o = builder.o;
        this.f = builder.g;
        this.m = builder.k;
        this.n = builder.l;
        this.s = builder.e;
        this.t = builder.f;
        this.x = HeatMap.a(this.q, (double)this.q / 3.0);
        this.a(this.s);
    }

    public int getMaxHigh() {
        return this.f;
    }

    public boolean isFrameAnimation() {
        if (this.o == null) {
            return false;
        }
        return this.o.getIsAnimation();
    }

    public boolean isInitAnimation() {
        if (this.p == null) {
            return false;
        }
        return this.p.getIsAnimation();
    }

    public void removeHeatMap() {
        if (this.a != null) {
            this.a.a(this);
        }
        if (this.l != null) {
            this.l.clear();
        }
        if (this.k != null) {
            this.k.clear();
        }
    }

    private void b(Collection<WeightedLatLng> data) {
        this.k = data;
        if (this.k.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }
        this.u = HeatMap.d(this.k);
        this.j = new ah(this.u);
        for (WeightedLatLng l2 : this.k) {
            this.j.a(l2);
        }
        this.y = this.a(this.q);
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    private static List<List<WeightedLatLng>> b(List<List<LatLng>> datas) {
        ArrayList<List<WeightedLatLng>> tempDatas = new ArrayList<List<WeightedLatLng>>();
        for (List<LatLng> cll : datas) {
            List val = (List)HeatMap.c(cll);
            tempDatas.add(val);
        }
        return tempDatas;
    }

    protected HeatMapData getData(int index, int zoom) {
        if (zoom > 23 || zoom < 4) {
            return null;
        }
        if (this.l == null && this.k == null) {
            return null;
        }
        if (this.l != null) {
            return this.b(index, zoom);
        }
        if (this.k != null) {
            return this.a(index, zoom);
        }
        return null;
    }

    private HeatMapData a(int index, int zoom) {
        float oneFrameMaxIntensity = 0.0f;
        if (this.k == null) {
            return null;
        }
        if (this.y != null) {
            oneFrameMaxIntensity = (float)this.y[zoom];
        }
        return new HeatMapData(this.k, oneFrameMaxIntensity);
    }

    private HeatMapData b(int index, int zoom) {
        if (this.l == null) {
            return null;
        }
        if (index >= this.l.size()) {
            return null;
        }
        Collection data = this.l.get(index);
        float frameMaxIntensity = 0.0f;
        if (this.z != null && this.z.size() > index) {
            double[] maxIntensityArray = this.z.get(index);
            frameMaxIntensity = (float)maxIntensityArray[zoom];
        }
        return new HeatMapData(data, frameMaxIntensity);
    }

    synchronized void a() {
        this.C.clear();
        this.A.clear();
    }

    private synchronized void a(String key, Tile tile) {
        this.A.put(key, tile);
    }

    private synchronized void d() {
        this.A.clear();
    }

    void b() {
        this.d();
    }

    void c() {
        this.B.shutdownNow();
    }

    private void a(int x2, int y2, int zoom) {
        double tileWidth = c.get(zoom);
        double padding = tileWidth * (double)this.q / 256.0;
        double tileWidthPadded = tileWidth + 2.0 * padding;
        double bucketWidth = tileWidthPadded / (double)(256 + this.q * 2);
        if (x2 < 0 || y2 < 0) {
            return;
        }
        double minX = (double)x2 * tileWidth - padding;
        double maxX = (double)(x2 + 1) * tileWidth + padding;
        double minY = (double)y2 * tileWidth - padding;
        double maxY = (double)(y2 + 1) * tileWidth + padding;
        v tileBounds = new v(minX, maxX, minY, maxY);
        v paddedBounds = new v(this.u.a - padding, this.u.c + padding, this.u.b - padding, this.u.d + padding);
        if (!tileBounds.a(paddedBounds)) {
            return;
        }
        Collection<WeightedLatLng> points = this.j.a(tileBounds);
        if (points.isEmpty()) {
            return;
        }
        double[][] intensity = new double[256 + this.q * 2][256 + this.q * 2];
        for (WeightedLatLng w2 : points) {
            Point p2 = w2.getPoint();
            int bucketX = (int)(((double)p2.x - minX) / bucketWidth);
            int bucketY = (int)((maxY - (double)p2.y) / bucketWidth);
            if (bucketX >= 256 + this.q * 2) {
                bucketX = 256 + this.q * 2 - 1;
            }
            if (bucketY >= 256 + this.q * 2) {
                bucketY = 256 + this.q * 2 - 1;
            }
            double[] dArray = intensity[bucketX];
            int n2 = bucketY;
            dArray[n2] = dArray[n2] + w2.intensity;
        }
        double[][] convolved = HeatMap.a(intensity, this.x);
        Bitmap bitmap = HeatMap.a(convolved, this.v, this.y[zoom - 1]);
        Tile t2 = HeatMap.a(bitmap);
        bitmap.recycle();
        bitmap = null;
        String key = x2 + "_" + y2 + "_" + zoom;
        this.a(key, t2);
        if (this.A.size() > E) {
            this.a();
        }
        if (this.a != null) {
            this.a.a();
        }
    }

    private void a(Gradient gradient) {
        this.s = gradient;
        this.v = gradient.a(this.t);
        this.w = gradient.a();
    }

    private double[] a(int radius) {
        int i2;
        double[] maxIntensityArray = new double[23];
        for (i2 = 4; i2 < 11; ++i2) {
            maxIntensityArray[i2] = HeatMap.a(this.k, this.u, radius, (int)(1280.0 * Math.pow(2.0, i2 - 3)));
            if (i2 != 4) continue;
            for (int j2 = 0; j2 < i2; ++j2) {
                maxIntensityArray[j2] = maxIntensityArray[i2];
            }
        }
        for (i2 = 11; i2 < 23; ++i2) {
            maxIntensityArray[i2] = maxIntensityArray[10];
        }
        return maxIntensityArray;
    }

    private static Tile a(Bitmap bitmap) {
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        byte[] bitmapData = buffer.array();
        return new Tile(256, 256, bitmapData);
    }

    private static v d(Collection<WeightedLatLng> points) {
        Iterator<WeightedLatLng> iter = points.iterator();
        WeightedLatLng first = iter.next();
        double minX = first.getPoint().x;
        double maxX = first.getPoint().x;
        double minY = first.getPoint().y;
        double maxY = first.getPoint().y;
        while (iter.hasNext()) {
            WeightedLatLng l2 = iter.next();
            double x2 = l2.getPoint().x;
            double y2 = l2.getPoint().y;
            if (x2 < minX) {
                minX = x2;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y2 < minY) {
                minY = y2;
            }
            if (!(y2 > maxY)) continue;
            maxY = y2;
        }
        return new v(minX, maxX, minY, maxY);
    }

    private static double[] a(int radius, double sd) {
        double[] kernel = new double[radius * 2 + 1];
        for (int i2 = -radius; i2 <= radius; ++i2) {
            kernel[i2 + radius] = Math.exp((double)(-i2 * i2) / (2.0 * sd * sd));
        }
        return kernel;
    }

    private static double[][] a(double[][] grid, double[] kernel) {
        int initial;
        double val;
        int y2;
        int x2;
        int radius = (int)Math.floor((double)kernel.length / 2.0);
        int dimOld = grid.length;
        int dim = dimOld - 2 * radius;
        int lowerLimit = radius;
        int upperLimit = radius + dim - 1;
        double[][] intermediate = new double[dimOld][dimOld];
        for (x2 = 0; x2 < dimOld; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                val = grid[x2][y2];
                if (val == 0.0) continue;
                int xUpperLimit = (upperLimit < x2 + radius ? upperLimit : x2 + radius) + 1;
                for (int x22 = initial = lowerLimit > x2 - radius ? lowerLimit : x2 - radius; x22 < xUpperLimit; ++x22) {
                    double[] dArray = intermediate[x22];
                    int n2 = y2;
                    dArray[n2] = dArray[n2] + val * kernel[x22 - (x2 - radius)];
                }
            }
        }
        double[][] outputGrid = new double[dim][dim];
        for (x2 = lowerLimit; x2 < upperLimit + 1; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                val = intermediate[x2][y2];
                if (val == 0.0) continue;
                int yUpperLimit = (upperLimit < y2 + radius ? upperLimit : y2 + radius) + 1;
                for (int y22 = initial = lowerLimit > y2 - radius ? lowerLimit : y2 - radius; y22 < yUpperLimit; ++y22) {
                    double[] dArray = outputGrid[x2 - radius];
                    int n3 = y22 - radius;
                    dArray[n3] = dArray[n3] + val * kernel[y22 - (y2 - radius)];
                }
            }
        }
        return outputGrid;
    }

    private static Bitmap a(double[][] grid, int[] colorMap, double max) {
        int maxColor = colorMap[colorMap.length - 1];
        double colorMapScaling = (double)(colorMap.length - 1) / max;
        int dim = grid.length;
        int[] colors = new int[dim * dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                double val = grid[j2][i2];
                int index = i2 * dim + j2;
                int col = (int)(val * colorMapScaling);
                if (val != 0.0) {
                    if (col < colorMap.length) {
                        colors[index] = colorMap[col];
                        continue;
                    }
                    colors[index] = maxColor;
                    continue;
                }
                colors[index] = 0;
            }
        }
        Bitmap tile = Bitmap.createBitmap((int)dim, (int)dim, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        tile.setPixels(colors, 0, dim, 0, 0, dim, dim);
        return tile;
    }

    private static double a(Collection<WeightedLatLng> points, v bounds, int radius, int screenDim) {
        double maxX = bounds.c;
        double minX = bounds.a;
        double maxY = bounds.d;
        double minY = bounds.b;
        double boundsDim = maxX - minX > maxY - minY ? maxX - minX : maxY - minY;
        int nBuckets = (int)((double)(screenDim / (2 * radius)) + 0.5);
        double scale = (double)nBuckets / boundsDim;
        LongSparseArray buckets = new LongSparseArray();
        double max = 0.0;
        for (WeightedLatLng l2 : points) {
            Double value;
            double x2 = l2.getPoint().x;
            double y2 = l2.getPoint().y;
            int xBucket = (int)((x2 - minX) * scale);
            int yBucket = (int)((y2 - minY) * scale);
            LongSparseArray column = (LongSparseArray)buckets.get((long)xBucket);
            if (column == null) {
                column = new LongSparseArray();
                buckets.put((long)xBucket, (Object)column);
            }
            if ((value = (Double)column.get((long)yBucket)) == null) {
                value = 0.0;
            }
            value = value + l2.intensity;
            column.put((long)yBucket, (Object)value);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public Bundle toBundle() {
        Bundle b2 = new Bundle();
        b2.putInt("grid_size", this.D);
        b2.putFloat("point_size_meter", (float)(this.r * 2));
        b2.putFloat("point_size", (float)(this.q * 2));
        b2.putFloat("max_hight", (float)this.f);
        b2.putFloat("alpha", (float)this.t);
        if (this.l != null) {
            b2.putInt("frame_count", this.l.size());
        } else if (this.k != null) {
            b2.putInt("frame_count", 1);
        }
        b2.putIntArray("color_array", this.v);
        b2.putFloatArray("color_start_points", this.w);
        b2.putBoolean("is_need_init_animation", this.p.getIsAnimation());
        b2.putBoolean("is_need_frame_animation", this.o.getIsAnimation());
        b2.putBoolean("point_size_is_meter", this.g);
        b2.putInt("init_animation_duration", this.p.getDuration());
        b2.putInt("init_animation_type", this.p.getAnimationType());
        b2.putInt("frame_animation_duration", this.o.getDuration());
        b2.putInt("frame_animation_type", this.o.getAnimationType());
        b2.putFloat("max_intentity", this.m);
        b2.putFloat("min_intentity", this.n);
        b2.putFloat("max_show_level", (float)this.h);
        b2.putFloat("min_show_level", (float)this.i);
        return b2;
    }

    /* synthetic */ HeatMap(Builder x02, x x1) {
        this(x02);
    }

    static /* synthetic */ void a(HeatMap x02, int x1, int x2, int x3) {
        x02.a(x1, x2, x3);
    }

    static {
        c.put(3, 0x800000);
        c.put(4, 0x400000);
        c.put(5, 0x200000);
        c.put(6, 0x100000);
        c.put(7, 524288);
        c.put(8, 262144);
        c.put(9, 131072);
        c.put(10, 65536);
        c.put(11, 32768);
        c.put(12, 16384);
        c.put(13, 8192);
        c.put(14, 4096);
        c.put(15, 2048);
        c.put(16, 1024);
        c.put(17, 512);
        c.put(18, 256);
        c.put(19, 128);
        c.put(20, 64);
        d = new int[]{Color.rgb((int)0, (int)0, (int)200), Color.rgb((int)0, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
        e = new float[]{0.08f, 0.4f, 1.0f};
        DEFAULT_GRADIENT = new Gradient(d, e);
        E = 0;
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private List<List<WeightedLatLng>> b;
        private int c = 12;
        private int d = 12;
        private Gradient e = DEFAULT_GRADIENT;
        private double f = 0.6;
        private int g = 0;
        private boolean h = false;
        private int i = 22;
        private int j = 4;
        private float k = 1.0f;
        private float l = 0.0f;
        private boolean m = false;
        private HeatMapAnimation n = new HeatMapAnimation(false, 100, HeatMapAnimation.AnimationType.Linear);
        private HeatMapAnimation o = new HeatMapAnimation(false, 100, HeatMapAnimation.AnimationType.Linear);

        public Builder maxIntensity(float intensity) {
            if (intensity < 0.0f || intensity <= this.l) {
                return this;
            }
            this.k = intensity;
            this.m = true;
            return this;
        }

        public Builder minIntensity(float intensity) {
            if (intensity < 0.0f) {
                this.l = 0.0f;
                return this;
            }
            if (intensity >= this.k) {
                return this;
            }
            this.l = intensity;
            return this;
        }

        public Builder initAnimation(HeatMapAnimation animation) {
            this.n = animation;
            return this;
        }

        public Builder frameAnimation(HeatMapAnimation animation) {
            this.o = animation;
            return this;
        }

        public Builder data(Collection<LatLng> data) {
            if (data == null || data.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (data.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            return this.weightedData(HeatMap.c(data));
        }

        public Builder datas(List<List<LatLng>> datas) {
            if (datas == null || datas.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input datas.");
            }
            if (datas.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            return this.weightedDatas(HeatMap.b(datas));
        }

        public Builder weightedData(Collection<WeightedLatLng> weightData) {
            if (weightData == null || weightData.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (weightData.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            this.a = weightData;
            return this;
        }

        public Builder weightedDatas(List<List<WeightedLatLng>> weightDatas) {
            if (weightDatas == null || weightDatas.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (weightDatas.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            this.b = weightDatas;
            return this;
        }

        public Builder radiusMeter(int radius) {
            if (radius < 10) {
                this.d = 10;
                return this;
            }
            if (radius > 50) {
                this.d = 50;
                return this;
            }
            this.d = radius;
            return this;
        }

        public Builder maxShowLevel(int maxLevel) {
            if (maxLevel < this.j) {
                return this;
            }
            if (maxLevel > 22) {
                this.i = 22;
            }
            this.i = maxLevel;
            return this;
        }

        public Builder minShowLevel(int minLevel) {
            if (minLevel < 4) {
                this.j = 4;
                return this;
            }
            if (minLevel > this.i) {
                return this;
            }
            this.j = minLevel;
            return this;
        }

        public Builder radius(int radius) {
            if (radius < 10) {
                this.c = 10;
                return this;
            }
            if (radius > 50) {
                this.c = 50;
                return this;
            }
            this.c = radius;
            return this;
        }

        public Builder maxHigh(int high) {
            if (high < 0) {
                return this;
            }
            if (high > 200) {
                this.g = 200;
                return this;
            }
            this.g = high;
            return this;
        }

        public Builder isRadiusMeter(boolean isMeter) {
            this.h = isMeter;
            return this;
        }

        public Builder gradient(Gradient gradient) {
            if (gradient == null) {
                throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
            }
            this.e = gradient;
            return this;
        }

        public Builder opacity(double opacity) {
            if (opacity < 0.0) {
                this.f = 0.0;
                return this;
            }
            if (opacity > 1.0) {
                this.f = 1.0;
                return this;
            }
            this.f = opacity;
            return this;
        }

        public HeatMap build() {
            if (this.a == null && this.b == null) {
                throw new IllegalStateException("BDMapSDKException: No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMap(this, null);
        }
    }
}

