/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import com.baidu.mapapi.map.GradientLine;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.model.LatLng;
import java.util.List;

public class GradientLineOptions
extends OverlayOptions {
    private List<LatLng> a;
    private List<Integer> b;
    private List<Integer> c;
    private int d = 5;
    private boolean e = true;
    private LineDirectionCross180 f = LineDirectionCross180.NONE;

    public GradientLineOptions setPoints(List<LatLng> points) {
        if (points == null) {
            throw new IllegalArgumentException("BDMapSDKException: points list can not be null");
        }
        if (points.size() < 2) {
            throw new IllegalArgumentException("BDMapSDKException: points count can not less than 2");
        }
        if (points.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: points list can not contains null");
        }
        this.a = points;
        return this;
    }

    public GradientLineOptions setColorIndex(List<Integer> indexList) {
        if (indexList == null) {
            throw new IllegalArgumentException("BDMapSDKException: indexs list can not be null");
        }
        if (indexList.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: indexs list can not contains null");
        }
        if (indexList.size() == 0) {
            throw new IllegalStateException("BDMapSDKException: indexs list size can not be Equal to zero");
        }
        this.b = indexList;
        return this;
    }

    public GradientLineOptions setWidth(int width) {
        if (width > 0) {
            this.d = width;
        }
        return this;
    }

    public GradientLineOptions setColorsValues(List<Integer> colors) {
        if (colors == null) {
            throw new IllegalArgumentException("BDMapSDKException: colors list can not be null");
        }
        if (colors.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: colors list can not contains null");
        }
        if (colors.size() == 0) {
            throw new IllegalStateException("BDMapSDKException: colors list list size can not be Equal to zero");
        }
        this.c = colors;
        return this;
    }

    public GradientLineOptions setLineDirectionCross180(LineDirectionCross180 lineDirectionCross180) {
        this.f = lineDirectionCross180;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.a;
    }

    public List<Integer> getIndexs() {
        return this.b;
    }

    public List<Integer> getColors() {
        return this.c;
    }

    public int getWidth() {
        return this.d;
    }

    public LineDirectionCross180 getLineDirectionCross180() {
        return this.f;
    }

    public GradientLineOptions visible(boolean visible) {
        this.e = visible;
        return this;
    }

    public boolean isVisible() {
        return this.e;
    }

    @Override
    Overlay a() {
        GradientLine gradientLine = new GradientLine();
        gradientLine.d = this.d;
        gradientLine.N = this.e;
        gradientLine.e = this.f;
        if (this.a == null || this.a.size() < 2) {
            throw new IllegalStateException("BDMapSDKException: when you add GradientLine, you must at least supply 2 points");
        }
        gradientLine.a = this.a;
        if (null == this.c) {
            throw new IllegalStateException("BDMapSDKException: colors list can not be null");
        }
        if (this.c.size() == 0) {
            throw new IllegalStateException("BDMapSDKException: colors list size can not be Equal to zero");
        }
        int[] cColors = new int[this.c.size()];
        int colorIndex = 0;
        for (Integer tempColor : this.c) {
            cColors[colorIndex] = tempColor;
            ++colorIndex;
        }
        gradientLine.c = cColors;
        if (this.b == null) {
            throw new IllegalStateException("BDMapSDKException: Indexs list can not be null");
        }
        if (this.b.size() == 0) {
            throw new IllegalStateException("BDMapSDKException: Indexs list size can not be Equal to zero");
        }
        int[] cIndex = new int[this.b.size()];
        int index = 0;
        for (Integer tempIndex : this.b) {
            cIndex[index] = tempIndex;
            ++index;
        }
        gradientLine.b = cIndex;
        return gradientLine;
    }

    public static enum LineDirectionCross180 {
        NONE,
        FROM_EAST_TO_WEST,
        FROM_WEST_TO_EAST;

    }
}

