/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import com.baidu.mapapi.map.GradientLineOptions;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapsdkplatform.comapi.map.h;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import java.util.List;

public class GradientLine
extends Overlay {
    List<LatLng> a;
    int[] b;
    int[] c;
    int d = 5;
    GradientLineOptions.LineDirectionCross180 e = GradientLineOptions.LineDirectionCross180.NONE;

    public GradientLine() {
        this.type = h.n;
    }

    public void setPoints(List<LatLng> points) {
        if (points == null) {
            throw new IllegalArgumentException("BDMapSDKException: points list can not be null");
        }
        if (points.size() < 2) {
            throw new IllegalArgumentException("BDMapSDKException: points count can not less than 2");
        }
        if (points.contains(null)) {
            throw new IllegalArgumentException("BDMapSDKException: points list can not contains null");
        }
        this.a = points;
        this.listener.c(this);
    }

    public void setColorIndex(int[] indexList) {
        if (null == indexList || 0 == indexList.length) {
            throw new IllegalArgumentException("BDMapSDKException: indexList can not empty");
        }
        this.b = indexList;
        this.listener.c(this);
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.d = width;
            this.listener.c(this);
        }
    }

    public void setColorList(int[] colorList) {
        if (null == colorList || 0 == colorList.length) {
            throw new IllegalArgumentException("BDMapSDKException: colorList can not empty");
        }
        this.c = colorList;
        this.listener.c(this);
    }

    public void lineDirectionCross180(GradientLineOptions.LineDirectionCross180 lineDirectionCross180) {
        this.e = lineDirectionCross180;
    }

    public List<LatLng> getPoints() {
        return this.a;
    }

    public int[] getIndexs() {
        return this.b;
    }

    public int[] getColors() {
        return this.c;
    }

    public float getWidth() {
        return this.d;
    }

    public GradientLineOptions.LineDirectionCross180 getLineDirectionCross180() {
        return this.e;
    }

    @Override
    Bundle a(Bundle b2) {
        super.a(b2);
        if (this.a == null || this.a.size() < 2) {
            throw new IllegalStateException("BDMapSDKException: when you add GradientLine, you must at least supply 2 points");
        }
        GeoPoint mcLocation = CoordUtil.ll2mc(this.a.get(0));
        b2.putDouble("location_x", mcLocation.getLongitudeE6());
        b2.putDouble("location_y", mcLocation.getLatitudeE6());
        b2.putInt("width", this.d);
        if (this.b == null) {
            throw new IllegalStateException("BDMapSDKException: Indexs array can not be null");
        }
        if (this.b.length == 0) {
            throw new IllegalStateException("BDMapSDKException: Indexs array size can not be Equal to zero");
        }
        GradientLine.a(this.a, this.e, b2);
        GradientLine.a(this.b, b2);
        if (null == this.c) {
            throw new IllegalStateException("BDMapSDKException: colors array can not be null");
        }
        if (this.c.length == 0) {
            throw new IllegalStateException("BDMapSDKException: colors array size can not be Equal to zero");
        }
        GradientLine.b(this.c, b2);
        return b2;
    }

    private static void a(List<LatLng> points, GradientLineOptions.LineDirectionCross180 lineDirectionCross180, Bundle b2) {
        int length = points.size();
        double[] xArray = new double[length];
        double[] yArray = new double[length];
        for (int i2 = 0; i2 < length; ++i2) {
            LatLng latLng = points.get(i2);
            if (lineDirectionCross180 == GradientLineOptions.LineDirectionCross180.FROM_EAST_TO_WEST && latLng.longitude < 0.0) {
                latLng = new LatLng(latLng.latitude, latLng.longitude + 360.0);
                b2.putInt("lineDirectionCross180", GradientLineOptions.LineDirectionCross180.FROM_EAST_TO_WEST.ordinal());
            } else if (lineDirectionCross180 == GradientLineOptions.LineDirectionCross180.FROM_WEST_TO_EAST && latLng.longitude > 0.0) {
                latLng = new LatLng(latLng.latitude, latLng.longitude - 360.0);
                b2.putInt("lineDirectionCross180", GradientLineOptions.LineDirectionCross180.FROM_WEST_TO_EAST.ordinal());
            } else {
                b2.putInt("lineDirectionCross180", GradientLineOptions.LineDirectionCross180.NONE.ordinal());
            }
            GeoPoint gp = CoordUtil.ll2mc(latLng);
            xArray[i2] = gp.getLongitudeE6();
            yArray[i2] = gp.getLatitudeE6();
        }
        b2.putDoubleArray("x_array", xArray);
        b2.putDoubleArray("y_array", yArray);
    }

    private static void a(int[] indexList, Bundle b2) {
        if (indexList != null && indexList.length > 0) {
            b2.putIntArray("color_indexs", indexList);
        }
    }

    private static void b(int[] colorList, Bundle b2) {
        if (colorList != null && colorList.length > 0) {
            b2.putIntArray("color_array", colorList);
        }
    }
}

