/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Color;
import com.baidu.mapapi.map.w;
import com.baidu.platform.comapi.util.e;
import java.util.HashMap;

public class Gradient {
    private final int b;
    private final int[] c;
    private final float[] d;
    float[] a;

    public Gradient(int[] colors, float[] startPoints) {
        this(colors, startPoints, 1000);
    }

    private Gradient(int[] colors, float[] startPoints, int colorMapSize) {
        colors = e.a(colors);
        if (colors == null || startPoints == null) {
            throw new IllegalArgumentException("BDMapSDKException: colors and startPoints should not be null");
        }
        if (colors.length != startPoints.length) {
            throw new IllegalArgumentException("BDMapSDKException: colors and startPoints should be same length");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("BDMapSDKException: No colors have been defined");
        }
        for (int i2 = 1; i2 < startPoints.length; ++i2) {
            if (!(startPoints[i2] <= startPoints[i2 - 1])) continue;
            throw new IllegalArgumentException("BDMapSDKException: startPoints should be in increasing order");
        }
        this.b = colorMapSize;
        this.c = new int[colors.length];
        this.d = new float[startPoints.length];
        System.arraycopy(colors, 0, this.c, 0, colors.length);
        System.arraycopy(startPoints, 0, this.d, 0, startPoints.length);
    }

    private HashMap<Integer, a> b() {
        int i2;
        HashMap<Integer, a> colorIntervals = new HashMap<Integer, a>();
        if (this.d[0] != 0.0f) {
            int initialColor = Color.argb((int)0, (int)Color.red((int)this.c[0]), (int)Color.green((int)this.c[0]), (int)Color.blue((int)this.c[0]));
            colorIntervals.put(0, new a(initialColor, this.c[0], (float)this.b * this.d[0], null));
        }
        for (i2 = 1; i2 < this.c.length; ++i2) {
            colorIntervals.put((int)((float)this.b * this.d[i2 - 1]), new a(this.c[i2 - 1], this.c[i2], (float)this.b * (this.d[i2] - this.d[i2 - 1]), null));
        }
        if (this.d[this.d.length - 1] != 1.0f) {
            i2 = this.d.length - 1;
            colorIntervals.put((int)((float)this.b * this.d[i2]), new a(this.c[i2], this.c[i2], (float)this.b * (1.0f - this.d[i2]), null));
        }
        return colorIntervals;
    }

    int[] a(double opacity) {
        int i2;
        HashMap<Integer, a> colorIntervals = this.b();
        int[] colorMap = new int[this.b];
        a interval = colorIntervals.get(0);
        int start = 0;
        for (i2 = 0; i2 < this.b; ++i2) {
            if (colorIntervals.containsKey(i2)) {
                interval = colorIntervals.get(i2);
                start = i2;
            }
            float ratio = (float)(i2 - start) / interval.d;
            colorMap[i2] = Gradient.a(interval.b, interval.c, ratio);
        }
        if (opacity != 1.0) {
            for (i2 = 0; i2 < this.b; ++i2) {
                int c2 = colorMap[i2];
                colorMap[i2] = Color.argb((int)((int)((double)Color.alpha((int)c2) * opacity)), (int)Color.red((int)c2), (int)Color.green((int)c2), (int)Color.blue((int)c2));
            }
        }
        return colorMap;
    }

    float[] a() {
        if (this.a == null) {
            this.a = new float[this.b];
            for (int i2 = 0; i2 < this.b; ++i2) {
                this.a[i2] = 0.001f * (float)(i2 + 1);
            }
            return this.a;
        }
        return this.a;
    }

    private static int a(int color1, int color2, float ratio) {
        int alpha = (int)((float)(Color.alpha((int)color2) - Color.alpha((int)color1)) * ratio + (float)Color.alpha((int)color1));
        float[] hsv1 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color1), (int)Color.green((int)color1), (int)Color.blue((int)color1), (float[])hsv1);
        float[] hsv2 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2), (float[])hsv2);
        if (hsv1[0] - hsv2[0] > 180.0f) {
            hsv2[0] = hsv2[0] + 360.0f;
        } else if (hsv2[0] - hsv1[0] > 180.0f) {
            hsv1[0] = hsv1[0] + 360.0f;
        }
        float[] result = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            result[i2] = (hsv2[i2] - hsv1[i2]) * ratio + hsv1[i2];
        }
        return Color.HSVToColor((int)alpha, (float[])result);
    }

    public int[] getColors() {
        return this.c;
    }

    public float[] getStartPoints() {
        return this.d;
    }

    private class a {
        private final int b;
        private final int c;
        private final float d;

        private a(int color1, int color2, float duration) {
            this.b = color1;
            this.c = color2;
            this.d = duration;
        }

        /* synthetic */ a(int x1, int x2, float x3, w x4) {
            this(x1, x2, x3);
        }
    }
}

