/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapsdkplatform.comapi.commonutils.a;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapDescriptorFactory {
    private static final String a = "BaiduMapSDK-" + BitmapDescriptorFactory.class.getSimpleName();

    public static BitmapDescriptor fromAsset(String assetName) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap b2 = com.baidu.mapsdkplatform.comapi.commonutils.a.a(assetName, context);
            BitmapDescriptor bd = null;
            bd = BitmapDescriptorFactory.fromBitmap(b2);
            if (b2 != null) {
                b2.recycle();
            }
            return bd;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromAssetWithDpi(String assetName) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap b2 = com.baidu.mapsdkplatform.comapi.commonutils.a.a(assetName, context);
            if (b2 == null) {
                return null;
            }
            Bitmap resizeBmp = null;
            BitmapDescriptor bd = null;
            int dpi = SysOSUtil.getDensityDpi();
            if (dpi > 480) {
                Matrix matrix = new Matrix();
                matrix.postScale(2.0f, 2.0f);
                resizeBmp = Bitmap.createBitmap((Bitmap)b2, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (Matrix)matrix, (boolean)true);
                bd = BitmapDescriptorFactory.fromBitmap(resizeBmp);
            } else if (dpi > 320) {
                Matrix matrix = new Matrix();
                matrix.postScale(1.5f, 1.5f);
                resizeBmp = Bitmap.createBitmap((Bitmap)b2, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (Matrix)matrix, (boolean)true);
                bd = BitmapDescriptorFactory.fromBitmap(resizeBmp);
            } else {
                bd = BitmapDescriptorFactory.fromBitmap(b2);
            }
            b2.recycle();
            if (resizeBmp != null) {
                resizeBmp.recycle();
            }
            return bd;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap image) {
        if (image == null) {
            return null;
        }
        return new BitmapDescriptor(image);
    }

    public static BitmapDescriptor fromFile(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        try {
            FileInputStream fis = context.openFileInput(fileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis);
            fis.close();
            if (bitmap != null) {
                BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(bitmap);
                bitmap.recycle();
                return bd;
            }
        }
        catch (FileNotFoundException e2) {
            Log.e((String)a, (String)"FileNotFoundException happened", (Throwable)e2);
        }
        catch (IOException e3) {
            Log.e((String)a, (String)"IOException happened", (Throwable)e3);
        }
        return null;
    }

    public static BitmapDescriptor fromFileWithDpi(String fileName, int targetDensityDpi) {
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        try {
            FileInputStream fis = context.openFileInput(fileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis);
            fis.close();
            if (bitmap != null) {
                if (targetDensityDpi <= 0) {
                    targetDensityDpi = SysOSUtil.getDensityDpi();
                }
                bitmap.setDensity(targetDensityDpi);
                BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(bitmap);
                bitmap.recycle();
                return bd;
            }
        }
        catch (FileNotFoundException e2) {
            Log.e((String)a, (String)"FileNotFoundException happened", (Throwable)e2);
        }
        catch (IOException e3) {
            Log.e((String)a, (String)"IOException happened", (Throwable)e3);
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String absolutePath) {
        if (TextUtils.isEmpty((CharSequence)absolutePath)) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)absolutePath);
        if (null == bitmap) {
            return null;
        }
        BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bd;
    }

    public static BitmapDescriptor fromPathWithDpi(String absolutePath, int targetDensityDpi) {
        if (TextUtils.isEmpty((CharSequence)absolutePath)) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)absolutePath);
        if (null == bitmap) {
            return null;
        }
        if (targetDensityDpi <= 0) {
            targetDensityDpi = SysOSUtil.getDensityDpi();
        }
        bitmap.setDensity(targetDensityDpi);
        BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bd;
    }

    public static BitmapDescriptor fromResource(int resourceId) {
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        Bitmap b2 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId);
        if (b2 == null) {
            return null;
        }
        BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(b2);
        b2.recycle();
        return bd;
    }

    public static BitmapDescriptor fromResourceWithDpi(int resourceId, int targetDensityDpi) {
        Context context = BMapManager.getContext();
        if (null == context) {
            return null;
        }
        Bitmap b2 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId);
        if (b2 == null) {
            return null;
        }
        if (targetDensityDpi <= 0) {
            targetDensityDpi = SysOSUtil.getDensityDpi();
        }
        b2.setDensity(targetDensityDpi);
        BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(b2);
        b2.recycle();
        return bd;
    }

    public static BitmapDescriptor fromView(View view) {
        if (view == null) {
            return null;
        }
        BitmapDescriptor bd = null;
        try {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            view.buildDrawingCache();
            Bitmap bitmap = view.getDrawingCache();
            bd = BitmapDescriptorFactory.fromBitmap(bitmap);
            if (bitmap != null) {
                bitmap.recycle();
            }
            view.destroyDrawingCache();
        }
        catch (Exception e2) {
            return null;
        }
        return bd;
    }

    public static BitmapDescriptor fromViewWithDpi(View view, int targetDensityDpi) {
        if (null == view) {
            return null;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        if (null == bitmap) {
            Log.e((String)a, (String)"Get bitmap failed");
            return null;
        }
        if (targetDensityDpi <= 0) {
            targetDensityDpi = SysOSUtil.getDensityDpi();
        }
        bitmap.setDensity(targetDensityDpi);
        BitmapDescriptor bd = BitmapDescriptorFactory.fromBitmap(bitmap);
        if (bitmap != null) {
            bitmap.recycle();
        }
        view.destroyDrawingCache();
        return bd;
    }
}

