/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.baidu.mapapi.map.AbsBackgroundDrawNaviLayer;
import com.baidu.mapapi.map.BackgroundDrawMapView;
import com.baidu.mapapi.map.entity.BackgroundNaviEntity;
import com.baidu.mapapi.map.entity.BackgroundNaviLocEntity;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comapi.map.MapStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BackgroundDrawNaviLayer
extends AbsBackgroundDrawNaviLayer {
    private Paint a;
    private Paint b;
    private Point c;
    private Path d;
    private Bitmap e;
    private final Object f = new Object();
    private Bitmap g;
    private final Object h = new Object();
    private Bitmap i;
    private final Object j = new Object();
    private a k;
    private a l;
    private double m;
    private boolean n = true;
    private int o = Color.parseColor((String)"#50D27D");
    private int p = 10;
    private boolean q = false;

    public BackgroundDrawNaviLayer(Context context) {
        super(context, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate() {
        super.onCreate();
        this.a = new Paint();
        this.a.setColor(this.o);
        this.a.setStyle(Paint.Style.STROKE);
        this.a.setStrokeWidth((float)this.p);
        this.a.setPathEffect((PathEffect)new CornerPathEffect(2.5f));
        this.b = new Paint();
        this.d = new Path();
        this.c = new Point();
        InputStream inputStream = null;
        try {
            if (this.e == null) {
                inputStream = this.mContext.getAssets().open("SDK_Default_Icon_Start.png");
                this.e = BitmapFactory.decodeStream((InputStream)inputStream);
                inputStream.close();
            }
            if (this.g == null) {
                inputStream = this.mContext.getAssets().open("SDK_Default_Icon_End.png");
                this.g = BitmapFactory.decodeStream((InputStream)inputStream);
                inputStream.close();
            }
        }
        catch (IOException e2) {
            this.e = null;
            this.g = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Object object = this.j;
        synchronized (object) {
            if (this.i == null) {
                try (InputStream is = this.mContext.getAssets().open("SDK_Default_Icon_Passenger.png");){
                    this.i = BitmapFactory.decodeStream((InputStream)is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onDraw(BackgroundDrawMapView.CanvasProxy canvas) {
        MapController controller = this.mController;
        if (controller == null) {
            return;
        }
        MapStatus mapStatus = controller.getMapStatus();
        if (mapStatus == null) {
            return;
        }
        MapStatus.WinRound winRound = mapStatus.winRound;
        if (winRound == null) {
            return;
        }
        int mapSourceW = Math.abs(winRound.right - winRound.left);
        int mapSourceH = Math.abs(winRound.bottom - winRound.top);
        if (mapSourceH <= 0 || mapSourceW <= 0) {
            return;
        }
        canvas.save();
        canvas.translate((float)(this.mWidth - mapSourceW) / 2.0f, (float)(this.mHeight - mapSourceH) / 2.0f);
        if (this.mWidth != mapSourceW && this.mHeight != mapSourceH) {
            float scale = this.mWidth >= mapSourceW && this.mHeight >= mapSourceH ? (float)Math.min(this.mWidth / mapSourceW, this.mHeight / mapSourceH) : (this.mWidth <= mapSourceW && this.mHeight <= mapSourceH ? (float)Math.min(mapSourceW / this.mWidth, mapSourceH / this.mHeight) : (this.mWidth <= mapSourceW ? (float)this.mHeight / (float)mapSourceH : (float)this.mWidth / (float)mapSourceW));
            canvas.scale(scale, scale, (float)this.mWidth / 2.0f, (float)this.mHeight / 2.0f);
        }
        this.a(canvas);
        this.b(canvas);
        canvas.restore();
    }

    public void updateNaviLocEntity(BackgroundNaviLocEntity naviLocEntity) {
        if (naviLocEntity == null) {
            return;
        }
        a curNaviLocEntityRecord = this.l;
        a record = new a(naviLocEntity);
        if (curNaviLocEntityRecord != null && curNaviLocEntityRecord.b.getGpsLatitude() == naviLocEntity.getGpsLatitude() && curNaviLocEntityRecord.b.getGpsLongitude() == naviLocEntity.getGpsLongitude()) {
            return;
        }
        this.k = curNaviLocEntityRecord;
        this.l = record;
    }

    public void updateHeading(double heading) {
        this.m = heading;
    }

    @Override
    public void setIsNeedShowStartAndEndMark(boolean isNeedShowStartAndEndMark) {
        this.n = isNeedShowStartAndEndMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNaviStartMark(Bitmap bitmap) {
        Object object = this.f;
        synchronized (object) {
            Bitmap startPointBp = this.e;
            if (startPointBp != null && !startPointBp.isRecycled()) {
                startPointBp.recycle();
            }
            this.e = bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNaviEndMark(Bitmap bitmap) {
        Object object = this.h;
        synchronized (object) {
            Bitmap endPointBp = this.g;
            if (endPointBp != null && !endPointBp.isRecycled()) {
                endPointBp.recycle();
            }
            this.g = bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNaviLocationMark(Bitmap bitmap) {
        Object object = this.j;
        synchronized (object) {
            Bitmap positionBp = this.i;
            if (positionBp != null && !positionBp.isRecycled()) {
                positionBp.recycle();
            }
            this.i = bitmap;
        }
    }

    @Override
    public void setNaviRouteColor(int resId) {
        this.o = this.mContext.getResources().getColor(resId);
    }

    @Override
    public void setNaviRouteWidth(int widthPx) {
        this.p = Math.min(30, Math.max(1, widthPx));
    }

    @Override
    public void setIsLocationDirectionFollowPhone(boolean isLocationDirectionFollowPhone) {
        this.q = isLocationDirectionFollowPhone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(BackgroundDrawMapView.CanvasProxy canvas) {
        BackgroundNaviEntity entity = (BackgroundNaviEntity)this.mEntity;
        if (entity == null) {
            return;
        }
        ArrayList<LatLng> routeShapePoints = entity.getRouteShapePoints();
        if (routeShapePoints == null || routeShapePoints.isEmpty()) {
            return;
        }
        int size = routeShapePoints.size();
        if (size < 2) {
            return;
        }
        this.d.reset();
        LatLng point = routeShapePoints.get(0);
        this.toScreenLocation(point, this.c);
        this.d.moveTo((float)this.c.x, (float)this.c.y);
        for (int i2 = 1; i2 < size; ++i2) {
            point = routeShapePoints.get(i2);
            this.toScreenLocation(point, this.c);
            this.d.lineTo((float)this.c.x, (float)this.c.y);
        }
        this.a.setColor(this.o);
        this.a.setStrokeWidth((float)this.p);
        canvas.drawPath(this.d, this.a);
        if (this.n) {
            Object object = this.f;
            synchronized (object) {
                Bitmap startPointBp = this.e;
                if (startPointBp != null && !startPointBp.isRecycled()) {
                    point = routeShapePoints.get(0);
                    this.toScreenLocation(point, this.c);
                    canvas.drawBitmap(startPointBp, (float)this.c.x - (float)startPointBp.getWidth() / 2.0f, this.c.y - startPointBp.getHeight(), this.b);
                }
            }
            object = this.h;
            synchronized (object) {
                Bitmap endPointBp = this.g;
                if (endPointBp != null && !endPointBp.isRecycled()) {
                    point = routeShapePoints.get(size - 1);
                    this.toScreenLocation(point, this.c);
                    canvas.drawBitmap(endPointBp, (float)this.c.x - (float)endPointBp.getWidth() / 2.0f, this.c.y - endPointBp.getHeight(), this.b);
                }
            }
        }
    }

    private void b(BackgroundDrawMapView.CanvasProxy canvas) {
        a curNaviLocEntityRecord = this.l;
        if (curNaviLocEntityRecord == null) {
            return;
        }
        Bitmap bitmap = this.i;
        if (bitmap == null) {
            return;
        }
        if (bitmap.isRecycled()) {
            return;
        }
        MapController controller = this.mController;
        if (controller == null) {
            return;
        }
        MapStatus mapStatus = controller.getMapStatus();
        if (mapStatus == null) {
            return;
        }
        List<Float> position = this.a();
        if (position == null) {
            return;
        }
        if (position.size() != 2) {
            return;
        }
        float x2 = position.get(0).floatValue();
        float y2 = position.get(1).floatValue();
        float degrees = !this.q ? curNaviLocEntityRecord.b.getGpsDirection() - (float)mapStatus.rotation : (float)(this.m - (double)mapStatus.rotation);
        canvas.save();
        canvas.rotate(degrees, x2, y2);
        canvas.drawBitmap(bitmap, x2 - (float)bitmap.getWidth() / 2.0f, y2 - (float)bitmap.getHeight() / 2.0f, this.b);
        canvas.restore();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Bitmap startPointBp = this.e;
        Bitmap endPointBp = this.g;
        Bitmap locationBp = this.i;
        if (startPointBp != null && !startPointBp.isRecycled()) {
            startPointBp.recycle();
        }
        if (endPointBp != null && !endPointBp.isRecycled()) {
            endPointBp.recycle();
        }
        if (locationBp != null && !locationBp.isRecycled()) {
            locationBp.recycle();
        }
        this.e = null;
        this.g = null;
        this.i = null;
    }

    private List<Float> a() {
        a curNaviLocEntityRecord = this.l;
        if (curNaviLocEntityRecord == null) {
            return null;
        }
        curNaviLocEntityRecord.a();
        ArrayList<Float> position = new ArrayList<Float>(2);
        a referNaviLocEntityRecord = this.k;
        if (referNaviLocEntityRecord == null) {
            position.add(Float.valueOf(curNaviLocEntityRecord.c));
            position.add(Float.valueOf(curNaviLocEntityRecord.d));
            return position;
        }
        referNaviLocEntityRecord.a();
        long totalDisTime = curNaviLocEntityRecord.e - referNaviLocEntityRecord.e;
        if (totalDisTime <= 0L) {
            position.add(Float.valueOf(curNaviLocEntityRecord.c));
            position.add(Float.valueOf(curNaviLocEntityRecord.d));
            return position;
        }
        long disTime = System.currentTimeMillis() - curNaviLocEntityRecord.e;
        if (disTime >= totalDisTime) {
            position.add(Float.valueOf(curNaviLocEntityRecord.c));
            position.add(Float.valueOf(curNaviLocEntityRecord.d));
            return position;
        }
        position.add(Float.valueOf((float)referNaviLocEntityRecord.c + (float)((long)(curNaviLocEntityRecord.c - referNaviLocEntityRecord.c) * disTime) / (float)totalDisTime));
        position.add(Float.valueOf((float)referNaviLocEntityRecord.d + (float)((long)(curNaviLocEntityRecord.d - referNaviLocEntityRecord.d) * disTime) / (float)totalDisTime));
        return position;
    }

    private class a {
        private final BackgroundNaviLocEntity b;
        private int c = -1;
        private int d = -1;
        private final long e;

        public a(BackgroundNaviLocEntity entity) {
            this.b = entity;
            this.e = System.currentTimeMillis();
        }

        public void a() {
            BackgroundDrawNaviLayer.this.toScreenLocation((int)this.b.getGpsLongitude(), (int)this.b.getGpsLatitude(), BackgroundDrawNaviLayer.this.c);
            this.c = ((BackgroundDrawNaviLayer)BackgroundDrawNaviLayer.this).c.x;
            this.d = ((BackgroundDrawNaviLayer)BackgroundDrawNaviLayer.this).c.y;
        }
    }
}

