/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.baidu.mapapi.map.BaseBackgroundDrawLayer;
import com.baidu.mapapi.map.IBackgroundDrawBaseRouteLayer;
import com.baidu.mapapi.map.IBackgroundDrawLayer;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.map.u;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comapi.map.MapSurfaceView;
import com.baidu.platform.comapi.map.MapTextureView;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDrawMapView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final int DEFAULT_FPS = 30;
    private static final int MAX_FPS = 60;
    private static final int MIN_FPS = 10;
    private MapTextureView mMapTextureView;
    private MapSurfaceView mMapSurfaceView;
    private MapController mController;
    private final List<IBackgroundDrawLayer> mLayers;
    private a mDrawThread;
    private final AtomicBoolean mIsReady = new AtomicBoolean(false);
    private volatile int mFps = 30;
    private final Object mDrawThreadLock = new Object();

    public BackgroundDrawMapView(Context context) {
        this(context, null);
    }

    public BackgroundDrawMapView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BackgroundDrawMapView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mLayers = new CopyOnWriteArrayList<IBackgroundDrawLayer>();
        this.mLayers.add(new com.baidu.mapapi.map.a(this.getContext()));
        this.setOnClickListener(new c(this));
        this.setSurfaceTextureListener(this);
    }

    public void setFps(int fps) {
        this.mFps = Math.min(60, Math.max(10, fps));
    }

    public void bindView(MapSurfaceView surfaceView) {
        a drawThread = this.mDrawThread;
        if (drawThread != null && drawThread.b.get()) {
            drawThread.interrupt();
        }
        this.mDrawThread = null;
        this.mController = null;
        this.mMapTextureView = null;
        this.mMapSurfaceView = surfaceView;
    }

    public void bindView(MapTextureView textureView) {
        a drawThread = this.mDrawThread;
        if (drawThread != null && drawThread.b.get()) {
            drawThread.interrupt();
        }
        this.mDrawThread = null;
        this.mController = null;
        this.mMapTextureView = textureView;
        this.mMapSurfaceView = null;
    }

    public boolean openBackgroundMap() {
        MapController controller = null;
        MapSurfaceView mapSurfaceView = this.mMapSurfaceView;
        if (mapSurfaceView != null) {
            controller = mapSurfaceView.getController();
            mapSurfaceView.setSupBackgroundDraw(true);
            mapSurfaceView.onBackground(true);
        }
        MapTextureView mapTextureView = this.mMapTextureView;
        if (controller == null && mapTextureView != null) {
            controller = mapTextureView.getController();
            mapTextureView.setSupBackgroundDraw(true);
            mapTextureView.onBackground(true);
        }
        if (controller == null) {
            return false;
        }
        this.setController(controller);
        return true;
    }

    public boolean closeBackgroundMap() {
        MapTextureView mapTextureView;
        MapSurfaceView mapSurfaceView = this.mMapSurfaceView;
        if (mapSurfaceView != null) {
            mapSurfaceView.setSupBackgroundDraw(false);
            mapSurfaceView.onForeground(true);
        }
        if ((mapTextureView = this.mMapTextureView) != null) {
            mapTextureView.setSupBackgroundDraw(false);
            mapTextureView.onForeground(true);
        }
        this.setController(null);
        return true;
    }

    public void addLayer(BaseBackgroundDrawLayer layer) {
        if (layer == null) {
            return;
        }
        if (this.mLayers.contains(layer)) {
            return;
        }
        this.mLayers.add(layer);
        if (this.mIsReady.get()) {
            if (layer instanceof u) {
                ((u)layer).updateMapController(this.mController);
            }
            layer.onCreate();
            layer.onSizeChanged(this.getWidth(), this.getHeight());
        }
        List<IBackgroundDrawLayer> list = Arrays.asList(this.mLayers.toArray(new IBackgroundDrawLayer[0]));
        Collections.sort(list, new d(this));
        this.mLayers.clear();
        this.mLayers.addAll(list);
    }

    public void removeLayer(BaseBackgroundDrawLayer layer) {
        if (layer == null) {
            return;
        }
        this.mLayers.remove(layer);
        if (this.mIsReady.get()) {
            layer.onDestroy();
        }
    }

    public IBackgroundDrawBaseRouteLayer getBaseRouteLayer() {
        for (IBackgroundDrawLayer layer : this.mLayers) {
            if (!(layer instanceof com.baidu.mapapi.map.a)) continue;
            return (com.baidu.mapapi.map.a)layer;
        }
        return null;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        for (IBackgroundDrawLayer layer : this.mLayers) {
            if (layer instanceof u) {
                ((u)layer).updateMapController(this.mController);
            }
            layer.onCreate();
            layer.onSizeChanged(width, height);
        }
        this.mIsReady.set(true);
        this.setController(this.mController);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        for (IBackgroundDrawLayer layer : this.mLayers) {
            layer.onSizeChanged(width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        a drawThread = this.mDrawThread;
        if (drawThread != null && drawThread.b.get()) {
            drawThread.interrupt();
        }
        for (IBackgroundDrawLayer layer : this.mLayers) {
            layer.onDestroy();
        }
        this.mIsReady.set(false);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        for (IBackgroundDrawLayer layer : this.mLayers) {
            layer.onUpdated();
        }
    }

    private void setController(MapController controller) {
        a drawThread = this.mDrawThread;
        if (drawThread != null && drawThread.b.get()) {
            drawThread.interrupt();
            while (drawThread.b.get()) {
            }
        }
        this.mDrawThread = null;
        this.mController = null;
        if (controller == null) {
            return;
        }
        this.mController = controller;
        if (!this.mIsReady.get()) {
            return;
        }
        for (IBackgroundDrawLayer layer : this.mLayers) {
            if (!(layer instanceof u)) continue;
            ((u)layer).updateMapController(controller);
        }
        this.mDrawThread = new a(null);
        this.mDrawThread.start();
    }

    public static class CanvasProxy {
        private final TextureView a;
        private Canvas b;

        public CanvasProxy(TextureView textureView) {
            this.a = textureView;
        }

        public Canvas lockCanvas() {
            TextureView textureView = this.a;
            if (textureView == null) {
                return null;
            }
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            this.b = textureView.lockCanvas();
            return this.b;
        }

        public void unlockCanvasAndPost(Canvas canvas) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            if (canvas == null) {
                canvas = this.b;
            }
            if (canvas == null) {
                return;
            }
            if (canvas != this.b) {
                return;
            }
            if (textureView.isAvailable()) {
                textureView.unlockCanvasAndPost(canvas);
                this.b = null;
            }
        }

        public void drawColor(int color) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.drawColor(color);
            }
        }

        public void drawPath(Path path, Paint paint) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.drawPath(path, paint);
            }
        }

        public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.drawBitmap(bitmap, left, top, paint);
            }
        }

        public int save() {
            TextureView textureView = this.a;
            if (textureView == null) {
                return -1;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return -1;
            }
            if (Thread.currentThread().isInterrupted()) {
                return -1;
            }
            if (textureView.isAvailable()) {
                return canvas.save();
            }
            return -1;
        }

        public void restore() {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.restore();
            }
        }

        public void rotate(float degrees) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.rotate(degrees);
            }
        }

        public void drawPoint(float x2, float y2, Paint paint) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.drawPoint(x2, y2, paint);
            }
        }

        public void rotate(float degrees, float px, float py) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.rotate(degrees, px, py);
            }
        }

        public void scale(float sx, float sy) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.scale(sx, sy);
            }
        }

        public void scale(float sx, float sy, float px, float py) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.scale(sx, sy, px, py);
            }
        }

        public void translate(float dx, float dy) {
            TextureView textureView = this.a;
            if (textureView == null) {
                return;
            }
            Canvas canvas = this.b;
            if (canvas == null) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (textureView.isAvailable()) {
                canvas.translate(dx, dy);
            }
        }
    }

    private class a
    extends Thread {
        private final AtomicBoolean b = new AtomicBoolean(false);

        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            Object object = BackgroundDrawMapView.this.mDrawThreadLock;
            synchronized (object) {
                this.b.set(true);
                int errNum = 0;
                long preFrameTime = 0L;
                CanvasProxy canvasProxy = new CanvasProxy(BackgroundDrawMapView.this);
                while (BackgroundDrawMapView.this.mIsReady.get() && !com.baidu.mapapi.map.BackgroundDrawMapView$a.interrupted()) {
                    if (canvasProxy.lockCanvas() == null) {
                        if (errNum > 3) break;
                        ++errNum;
                        try {
                            BackgroundDrawMapView.this.mDrawThreadLock.wait(100L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                    }
                    try {
                        AppBaseMap baseMap;
                        MapController controller = BackgroundDrawMapView.this.mController;
                        if (controller == null || (baseMap = controller.getBaseMap()) == null) break;
                        baseMap.Draw();
                        this.a(canvasProxy, BackgroundDrawMapView.this.mLayers, baseMap);
                        if (this.isInterrupted()) break;
                        errNum = 0;
                    }
                    catch (Exception ex) {
                        if (this.isInterrupted() || errNum > 3) break;
                        try {
                            BackgroundDrawMapView.this.mDrawThreadLock.wait(100L);
                        }
                        catch (InterruptedException e3) {
                            this.interrupt();
                        }
                        ++errNum;
                    }
                    finally {
                        canvasProxy.unlockCanvasAndPost(null);
                    }
                    long space = (long)(1000 / BackgroundDrawMapView.this.mFps) - (System.currentTimeMillis() - preFrameTime);
                    if (space > 0L) {
                        try {
                            BackgroundDrawMapView.this.mDrawThreadLock.wait(space);
                        }
                        catch (InterruptedException e4) {
                            break;
                        }
                    }
                    preFrameTime = System.currentTimeMillis();
                }
                this.b.set(false);
            }
        }

        private void a(CanvasProxy canvasProxy, List<IBackgroundDrawLayer> layers, AppBaseMap baseMap) {
            for (IBackgroundDrawLayer layer : layers) {
                if (layer instanceof com.baidu.mapapi.map.a) {
                    ((com.baidu.mapapi.map.a)layer).updateEntity(baseMap.getBaseRoadData());
                }
                layer.onDraw(canvasProxy);
            }
        }

        /* synthetic */ a(c x1) {
            this();
        }
    }
}

