/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.baidu.mapapi.b;
import com.baidu.mapsdkplatform.comapi.util.SysUpdateObservable;

public class NetworkUtil {
    public static boolean a = false;

    public static void updateNetworkProxy(Context context) {
        SysUpdateObservable.getInstance().updateNetworkProxy(context);
    }

    public static boolean isWifiConnected(NetworkInfo activeNetInfo) {
        boolean isWifiConnected = false;
        try {
            if (activeNetInfo != null) {
                isWifiConnected = 1 == activeNetInfo.getType() && activeNetInfo.isConnected();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return isWifiConnected;
    }

    public static boolean initConnectState() {
        return true;
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeInfo = null;
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                NetworkRequest request = builder.build();
                if (null != manager && !a) {
                    b mNetworkCallback = new b(context);
                    manager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)mNetworkCallback);
                    a = true;
                }
            } else {
                activeInfo = manager.getActiveNetworkInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activeInfo;
    }

    public static String getCurrentNetMode(Context context) {
        int netype = 0;
        if (context == null) {
            return null;
        }
        NetworkInfo info = NetworkUtil.getActiveNetworkInfo(context);
        if (null != info) {
            if (info.getType() == 1) {
                netype = 1;
            } else {
                if (Build.VERSION.SDK_INT > 29) {
                    String networkType = "mobile";
                    ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (manager == null) {
                        return networkType;
                    }
                    Network network = manager.getActiveNetwork();
                    NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(network);
                    if (networkCapabilities != null) {
                        boolean hasTransportWifi = networkCapabilities.hasTransport(1);
                        boolean hasTransportCellular = networkCapabilities.hasTransport(0);
                        boolean hasTransportEthernet = networkCapabilities.hasTransport(3);
                        boolean hasTransportLoWPAN = networkCapabilities.hasTransport(6);
                        boolean hasTransportVPN = networkCapabilities.hasTransport(4);
                        boolean hasTransportWifiAware = networkCapabilities.hasTransport(5);
                        if (hasTransportWifi) {
                            networkType = "WIFI";
                        } else if (hasTransportCellular) {
                            networkType = "CELLULAR";
                        } else if (hasTransportEthernet) {
                            networkType = "ETHERNET";
                        } else if (hasTransportLoWPAN) {
                            networkType = "LoWPAN";
                        } else if (hasTransportVPN) {
                            networkType = "VPN";
                        } else if (hasTransportWifiAware) {
                            networkType = "WifiAware";
                        }
                    }
                    return networkType;
                }
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (null == tm) {
                    return Integer.toString(netype);
                }
                int type = tm.getNetworkType();
                switch (type) {
                    case 11: {
                        netype = 2;
                        break;
                    }
                    case 13: {
                        netype = 4;
                        break;
                    }
                    case 4: {
                        netype = 5;
                        break;
                    }
                    case 1: 
                    case 2: {
                        netype = 6;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 12: {
                        netype = 7;
                        break;
                    }
                    case 8: {
                        netype = 8;
                        break;
                    }
                    case 3: 
                    case 9: 
                    case 10: 
                    case 15: {
                        netype = 9;
                        break;
                    }
                    case 14: {
                        netype = 10;
                        break;
                    }
                }
            }
        }
        return Integer.toString(netype);
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            if (NetworkUtil.isWifiConnected(context)) {
                return true;
            }
            ConnectivityManager cManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cManager.getActiveNetworkInfo();
            return info != null && info.isConnectedOrConnecting();
        }
        catch (Exception var3) {
            return false;
        }
    }

    public static boolean isWifiConnected(Context context) {
        if (context == null) {
            return false;
        }
        boolean isWifiConnected = false;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            try {
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetInfo != null) {
                    isWifiConnected = 1 == activeNetInfo.getType() && activeNetInfo.isConnected();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isWifiConnected;
    }
}

